/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.TypeDesc;

public class ConstantClassInfo
extends ConstantInfo {
    private final TypeDesc mType;
    private final ConstantUTFInfo mNameConstant;

    static ConstantClassInfo make(ConstantPool cp, String className) {
        ConstantClassInfo ci = new ConstantClassInfo(cp, className);
        return (ConstantClassInfo)cp.addConstant(ci);
    }

    static ConstantClassInfo make(ConstantPool cp, String className, int dim) {
        ConstantClassInfo ci = new ConstantClassInfo(cp, className, dim);
        return (ConstantClassInfo)cp.addConstant(ci);
    }

    static ConstantClassInfo make(ConstantPool cp, TypeDesc type) {
        ConstantClassInfo ci = new ConstantClassInfo(cp, type);
        return (ConstantClassInfo)cp.addConstant(ci);
    }

    ConstantClassInfo(ConstantUTFInfo nameConstant) {
        super(7);
        String name = nameConstant.getValue();
        this.mType = !name.endsWith(";") && !name.startsWith("[") ? TypeDesc.forClass(name) : TypeDesc.forDescriptor(name);
        this.mNameConstant = nameConstant;
    }

    private ConstantClassInfo(ConstantPool cp, String className) {
        super(7);
        String desc = className.replace('.', '/');
        this.mType = TypeDesc.forClass(className);
        this.mNameConstant = ConstantUTFInfo.make(cp, desc);
    }

    private ConstantClassInfo(ConstantPool cp, String className, int dim) {
        super(7);
        String desc;
        TypeDesc type = TypeDesc.forClass(className);
        if (dim > 0) {
            while (--dim >= 0) {
                type = type.toArrayType();
            }
            desc = type.toString();
        } else {
            desc = className.replace('.', '/');
        }
        this.mType = type;
        this.mNameConstant = ConstantUTFInfo.make(cp, desc);
    }

    private ConstantClassInfo(ConstantPool cp, TypeDesc type) {
        super(7);
        String desc = type.isArray() ? type.toString() : type.getRootName().replace('.', '/');
        this.mType = type;
        this.mNameConstant = ConstantUTFInfo.make(cp, desc);
    }

    public TypeDesc getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstantClassInfo) {
            ConstantClassInfo other = (ConstantClassInfo)obj;
            return this.mType.equals(other.mType);
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mNameConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_Class_info: ".concat(this.getType().getFullName());
    }
}

