/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.teatrove.trove.classfile.CodeAssembler;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.Opcode;
import org.teatrove.trove.classfile.TypeDesc;

public class CodeAssemblerPrinter
implements CodeAssembler {
    private TypeDesc[] mParamTypes;
    private boolean mIsStatic;
    private PrintWriter mWriter;
    private String mLinePrefix;
    private String mLineSuffix;
    private int mLocalCounter;
    private int mLabelCounter;
    private int mTypeDescCounter;
    private Map mTypeDescNames;
    private int mTypeDescArrayCounter;
    private Map mTypeDescArrayNames;

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer) {
        this(paramTypes, isStatic, writer, null, null);
    }

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer, String linePrefix, String lineSuffix) {
        this.mParamTypes = paramTypes;
        this.mIsStatic = isStatic;
        this.mWriter = writer;
        this.mLinePrefix = linePrefix;
        this.mLineSuffix = lineSuffix;
        this.mTypeDescNames = new HashMap();
        this.mTypeDescArrayNames = new HashMap();
    }

    @Override
    public LocalVariable[] getParameters() {
        LocalVariable[] vars = new LocalVariable[this.mParamTypes.length];
        int varNum = this.mIsStatic ? 0 : 1;
        for (int i = 0; i < this.mParamTypes.length; ++i) {
            String varName = "var_" + ++this.mLocalCounter;
            this.println("LocalVariable " + varName + " = getParameters()[" + i + ']');
            NamedLocal localVar = new NamedLocal(varName, this.mParamTypes[i], varNum);
            varNum += localVar.isDoubleWord() ? 2 : 1;
            vars[i] = localVar;
        }
        return vars;
    }

    @Override
    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        String varName = "var_" + ++this.mLocalCounter;
        if (name != null) {
            name = '\"' + name + '\"';
        }
        this.println("LocalVariable " + varName + " = createLocalVariable(" + name + ", " + this.getTypeDescName(type) + ')');
        return new NamedLocal(varName, type, -1);
    }

    @Override
    public Label createLabel() {
        String name = "label_" + ++this.mLabelCounter;
        this.println("Label " + name + " = createLabel()");
        return new NamedLabel(name);
    }

    @Override
    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        this.println("exceptionHandler(" + this.getLabelName(startLocation) + ", " + this.getLabelName(endLocation) + ", " + catchClassName + ')');
    }

    @Override
    public void mapLineNumber(int lineNumber) {
        this.println("mapLineNumber(" + lineNumber + ')');
    }

    @Override
    public void loadConstant(String value) {
        if (value == null) {
            this.println("loadConstant(null)");
        } else {
            this.println("loadConstant(\"" + this.escape(value) + "\")");
        }
    }

    @Override
    public void loadConstant(boolean value) {
        this.println("loadConstant(" + value + ')');
    }

    @Override
    public void loadConstant(int value) {
        this.println("loadConstant(" + value + ')');
    }

    @Override
    public void loadConstant(long value) {
        this.println("loadConstant(" + value + "L)");
    }

    @Override
    public void loadConstant(float value) {
        this.println("loadConstant(" + value + "f)");
    }

    @Override
    public void loadConstant(double value) {
        this.println("loadConstant(" + value + "d)");
    }

    @Override
    public void loadLocal(LocalVariable local) {
        this.println("loadLocal(" + local.getName() + ')');
    }

    @Override
    public void loadThis() {
        this.println("loadThis()");
    }

    @Override
    public void storeLocal(LocalVariable local) {
        this.println("storeLocal(" + local.getName() + ')');
    }

    @Override
    public void loadFromArray(TypeDesc type) {
        this.println("loadFromArray(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeToArray(TypeDesc type) {
        this.println("storeToArray(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadField(String fieldName, TypeDesc type) {
        this.println("loadField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadField(String className, String fieldName, TypeDesc type) {
        this.println("loadField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadStaticField(String fieldName, TypeDesc type) {
        this.println("loadStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.println("loadStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeField(String fieldName, TypeDesc type) {
        this.println("storeField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeField(String className, String fieldName, TypeDesc type) {
        this.println("storeField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeStaticField(String fieldName, TypeDesc type) {
        this.println("storeStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.println("storeStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void returnVoid() {
        this.println("returnVoid()");
    }

    @Override
    public void returnValue(TypeDesc type) {
        this.println("returnValue(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.println("convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ')');
    }

    @Override
    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeVirtual(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeVirtual(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeStatic(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeStatic(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeInterface(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokePrivate(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println("invokeSuper(\"" + superClassName + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeConstructor(TypeDesc[] params) {
        this.println("invokeConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeConstructor(String className, TypeDesc[] params) {
        this.println("invokeConstructor(\"" + className + "\", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeSuperConstructor(TypeDesc[] params) {
        this.println("invokeSuperConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void newObject(TypeDesc type) {
        this.println("newObject(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions == 0 && !type.isArray()) {
            this.newObject(type);
        } else {
            this.println("newObject(" + this.getTypeDescName(type) + ", " + dimensions + ')');
        }
    }

    @Override
    public void dup() {
        this.println("dup()");
    }

    @Override
    public void dupX1() {
        this.println("dupX1()");
    }

    @Override
    public void dupX2() {
        this.println("dupX2()");
    }

    @Override
    public void dup2() {
        this.println("dup2()");
    }

    @Override
    public void dup2X1() {
        this.println("dup2X1()");
    }

    @Override
    public void dup2X2() {
        this.println("dup2X2()");
    }

    @Override
    public void pop() {
        this.println("pop()");
    }

    @Override
    public void pop2() {
        this.println("pop2()");
    }

    @Override
    public void swap() {
        this.println("swap()");
    }

    @Override
    public void swap2() {
        this.println("swap2()");
    }

    @Override
    public void branch(Location location) {
        this.println("branch(" + this.getLabelName(location) + ')');
    }

    @Override
    public void ifNullBranch(Location location, boolean choice) {
        this.println("ifNullBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    @Override
    public void ifEqualBranch(Location location, boolean choice) {
        this.println("ifEqualBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    @Override
    public void ifZeroComparisonBranch(Location location, String choice) {
        this.println("ifZeroComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    @Override
    public void ifComparisonBranch(Location location, String choice) {
        this.println("ifComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    @Override
    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        int i;
        StringBuffer buf = new StringBuffer(cases.length * 15);
        buf.append("switchBranch(");
        buf.append("new int[] {");
        for (i = 0; i < cases.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(cases[i]);
        }
        buf.append("}");
        buf.append(", ");
        buf.append("new Location[] {");
        for (i = 0; i < locations.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getLabelName(locations[i]));
        }
        buf.append("}");
        buf.append(", ");
        buf.append(this.getLabelName(defaultLocation));
        buf.append(')');
        this.println(buf.toString());
    }

    @Override
    public void jsr(Location location) {
        this.println("jsr(" + this.getLabelName(location) + ')');
    }

    @Override
    public void ret(LocalVariable local) {
        this.println("ret(" + local.getName() + ')');
    }

    @Override
    public void math(byte opcode) {
        this.println("math(Opcode." + Opcode.getMnemonic(opcode).toUpperCase() + ')');
    }

    @Override
    public void arrayLength() {
        this.println("arrayLength()");
    }

    @Override
    public void throwObject() {
        this.println("throwObject()");
    }

    @Override
    public void checkCast(TypeDesc type) {
        this.println("checkCast(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void instanceOf(TypeDesc type) {
        this.println("instanceOf(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void integerIncrement(LocalVariable local, int amount) {
        this.println("integerIncrement(" + local.getName() + ", " + amount + ')');
    }

    @Override
    public void monitorEnter() {
        this.println("monitorEnter()");
    }

    @Override
    public void monitorExit() {
        this.println("monitorExit()");
    }

    @Override
    public void nop() {
        this.println("nop()");
    }

    @Override
    public void breakpoint() {
        this.println("breakpoint()");
    }

    public void println(String str) {
        if (this.mLinePrefix != null) {
            this.mWriter.print(this.mLinePrefix);
        }
        if (this.mLineSuffix == null) {
            this.mWriter.println(str);
        } else {
            this.mWriter.print(str);
            this.mWriter.println(this.mLineSuffix);
        }
    }

    private String getLabelName(Location location) {
        if (location instanceof NamedLabel) {
            return ((NamedLabel)location).mName;
        }
        return ((NamedLabel)this.createLabel()).mName;
    }

    private String getTypeDescName(TypeDesc type) {
        if (type == null) {
            return "null";
        }
        String name = (String)this.mTypeDescNames.get(type);
        if (name == null) {
            if (type.isPrimitive()) {
                name = "TypeDesc.".concat(type.getRootName().toUpperCase());
                this.mTypeDescNames.put(type, name);
                return name;
            }
            if (type == TypeDesc.OBJECT) {
                name = "TypeDesc.OBJECT";
                this.mTypeDescNames.put(type, "TypeDesc.OBJECT");
                return name;
            }
            if (type == TypeDesc.STRING) {
                name = "TypeDesc.STRING";
                this.mTypeDescNames.put(type, "TypeDesc.STRING");
                return name;
            }
            name = "type_" + ++this.mTypeDescCounter;
            this.mTypeDescNames.put(type, name);
            StringBuffer buf = new StringBuffer("TypeDesc ");
            buf.append(name);
            buf.append(" = ");
            TypeDesc componentType = type.getComponentType();
            if (componentType != null) {
                buf.append(this.getTypeDescName(componentType));
                buf.append(".toArray(");
            } else {
                buf.append("TypeDesc.forClass(");
                buf.append('\"');
                buf.append(type.getRootName());
                buf.append('\"');
            }
            buf.append(')');
            this.println(buf.toString());
        }
        return name;
    }

    private String getTypeDescArrayName(TypeDesc[] types) {
        if (types == null) {
            return "null";
        }
        List<TypeDesc> key = Arrays.asList(types);
        String name = (String)this.mTypeDescArrayNames.get(key);
        if (name == null) {
            name = "params_" + ++this.mTypeDescArrayCounter;
            this.mTypeDescArrayNames.put(key, name);
            StringBuffer buf = new StringBuffer("TypeDesc[] ");
            buf.append(name);
            buf.append(" = new TypeDesc[] {");
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.getTypeDescName(types[i]));
            }
            buf.append('}');
            this.println(buf.toString());
        }
        return name;
    }

    private String escape(String value) {
        char c;
        int i;
        int length = value.length();
        for (i = 0; i < length && (c = value.charAt(i)) >= ' ' && c <= '~' && c != '\"' && c != '\\'; ++i) {
        }
        if (i >= length) {
            return value;
        }
        StringBuffer buf = new StringBuffer(length + 16);
        block11: for (i = 0; i < length; ++i) {
            char c2 = value.charAt(i);
            if (c2 >= ' ' && c2 <= '~' && c2 != '\"' && c2 != '\\') {
                buf.append(c2);
                continue;
            }
            switch (c2) {
                case '\u0000': {
                    buf.append("\\0");
                    continue block11;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block11;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block11;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block11;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block11;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block11;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block11;
                }
                default: {
                    String u = Integer.toHexString(c2).toLowerCase();
                    buf.append("\\u");
                    for (int len = u.length(); len < 4; ++len) {
                        buf.append('0');
                    }
                    buf.append(u);
                }
            }
        }
        return buf.toString();
    }

    private class NamedLabel
    implements Label {
        public final String mName;

        public NamedLabel(String name) {
            this.mName = name;
        }

        @Override
        public Label setLocation() {
            CodeAssemblerPrinter.this.println(this.mName + ".setLocation()");
            return this;
        }

        @Override
        public int getLocation() {
            return -1;
        }

        public int compareTo(Object obj) {
            return 0;
        }
    }

    private class NamedLocal
    implements LocalVariable {
        private String mName;
        private TypeDesc mType;
        private int mNumber;

        public NamedLocal(String name, TypeDesc type, int number) {
            this.mName = name;
            this.mType = type;
            this.mNumber = number;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            CodeAssemblerPrinter.this.println(this.mName + ".setName(" + name + ')');
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.mType.isDoubleWord();
        }

        @Override
        public int getNumber() {
            return this.mNumber;
        }

        public Location getStartLocation() {
            return null;
        }

        public Location getEndLocation() {
            return null;
        }

        public SortedSet getLocationRangeSet() {
            return null;
        }
    }
}

