/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.AttributeFactory;
import org.teatrove.trove.classfile.CodeAttr;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.ConstantValueAttr;
import org.teatrove.trove.classfile.DeprecatedAttr;
import org.teatrove.trove.classfile.ExceptionsAttr;
import org.teatrove.trove.classfile.InnerClassesAttr;
import org.teatrove.trove.classfile.LineNumberTableAttr;
import org.teatrove.trove.classfile.LocalVariableTableAttr;
import org.teatrove.trove.classfile.SignatureAttr;
import org.teatrove.trove.classfile.SourceFileAttr;
import org.teatrove.trove.classfile.SyntheticAttr;

public abstract class Attribute {
    static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    static final String CODE = "Code";
    static final String CONSTANT_VALUE = "ConstantValue";
    static final String DEPRECATED = "Deprecated";
    static final String EXCEPTIONS = "Exceptions";
    static final String INNER_CLASSES = "InnerClasses";
    static final String LINE_NUMBER_TABLE = "LineNumberTable";
    static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    static final String SOURCE_FILE = "SourceFile";
    static final String SYNTHETIC = "Synthetic";
    static final String SIGNATURE = "Signature";
    protected final ConstantPool mCp;
    private String mName;
    private ConstantUTFInfo mNameConstant;

    protected Attribute(ConstantPool cp, String name) {
        this.mCp = cp;
        this.mName = name;
        this.mNameConstant = ConstantUTFInfo.make(cp, name);
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public String getName() {
        return this.mName;
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public Attribute[] getAttributes() {
        return NO_ATTRIBUTES;
    }

    public abstract int getLength();

    public final void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeInt(this.getLength());
        this.writeDataTo(dout);
    }

    public void writeDataTo(DataOutput dout) throws IOException {
    }

    public static Attribute readFrom(ConstantPool cp, DataInput din, AttributeFactory attrFactory) throws IOException {
        int index = din.readUnsignedShort();
        String name = ((ConstantUTFInfo)cp.getConstant(index)).getValue();
        int length = din.readInt();
        attrFactory = new Factory(attrFactory);
        return attrFactory.createAttribute(cp, name, length, din);
    }

    private static class Factory
    implements AttributeFactory {
        private final AttributeFactory mAttrFactory;

        public Factory(AttributeFactory attrFactory) {
            this.mAttrFactory = attrFactory;
        }

        @Override
        public Attribute createAttribute(ConstantPool cp, String name, final int length, DataInput din) throws IOException {
            Attribute attr;
            if (name.equals(Attribute.CODE)) {
                return CodeAttr.define(cp, name, length, din, this.mAttrFactory);
            }
            if (name.equals(Attribute.CONSTANT_VALUE)) {
                return ConstantValueAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.DEPRECATED)) {
                return DeprecatedAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.EXCEPTIONS)) {
                return ExceptionsAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.INNER_CLASSES)) {
                return InnerClassesAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.LINE_NUMBER_TABLE)) {
                return LineNumberTableAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.LOCAL_VARIABLE_TABLE)) {
                return LocalVariableTableAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.SOURCE_FILE)) {
                return SourceFileAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.SYNTHETIC)) {
                return SyntheticAttr.define(cp, name, length, din);
            }
            if (name.equals(Attribute.SIGNATURE)) {
                return SignatureAttr.define(cp, name, length, din);
            }
            if (this.mAttrFactory != null && (attr = this.mAttrFactory.createAttribute(cp, name, length, din)) != null) {
                return attr;
            }
            final byte[] data = new byte[length];
            din.readFully(data);
            return new Attribute(cp, name){

                @Override
                public int getLength() {
                    return length;
                }

                @Override
                public void writeDataTo(DataOutput dout) throws IOException {
                    dout.write(data);
                }
            };
        }
    }
}

