/*
 * Decompiled with CFR 0.152.
 */
package scj.result;

import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.result.ConfigurableResult;
import scj.result.Result;

public class CountResultList
extends ConfigurableResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountResultList.class);
    protected BigInteger size = BigInteger.ZERO;

    public CountResultList() {
    }

    public CountResultList(String algName) {
        super(algName);
    }

    @Override
    public void add(int r, int s) {
        this.size = this.size.add(BigInteger.ONE);
    }

    @Override
    public void output() {
        LOGGER.info("size: {}", (Object)this.size.abs());
    }

    @Override
    public void add(Result result) {
        if (result instanceof CountResultList) {
            this.size.add(((CountResultList)result).size);
        }
    }

    @Override
    public Result getSubresult() {
        return new CountResultList();
    }

    public BigInteger getSize() {
        return this.size;
    }
}

