/*
 * Decompiled with CFR 0.152.
 */
package scj.input.statistics;

import java.util.HashSet;
import java.util.Set;
import scj.input.DataTuple;
import scj.input.InputReader;
import scj.input.datasets.BMSInputReader;
import scj.input.datasets.FlickrInputReader;
import scj.input.datasets.KosarakInputReader;
import scj.input.datasets.LgylymInputReaderOrkut;
import scj.input.datasets.LgylymInputReaderWebbase;
import scj.input.datasets.NetflixInputReader;

public class DatasetStats {
    public static void main(String[] args) {
        new DatasetStats(new BMSInputReader());
        new DatasetStats(new FlickrInputReader());
        new DatasetStats(new KosarakInputReader());
        new DatasetStats(new NetflixInputReader());
        new DatasetStats(new LgylymInputReaderOrkut());
        new DatasetStats(new LgylymInputReaderWebbase());
    }

    public DatasetStats(InputReader input) {
        Set<DataTuple> tuples = input.getDataTuples()[0];
        int tupleCount = tuples.size();
        int maxTupleSize = 0;
        int countElements = 0;
        HashSet<Integer> alphabet = new HashSet<Integer>();
        for (DataTuple tuple : tuples) {
            int length = tuple.getSet().length;
            if (maxTupleSize < length) {
                maxTupleSize = length;
            }
            countElements += length;
            int i = 0;
            while (i < length) {
                alphabet.add(tuple.getSet()[i]);
                ++i;
            }
        }
        int alphabetSize = alphabet.size();
        System.out.println(String.valueOf(input.getClass().getName()) + "\t" + tupleCount + "\t" + maxTupleSize + "\t" + countElements + "\t" + alphabetSize);
    }
}

