/*
 * Decompiled with CFR 0.152.
 */
package scj.evaluation.evals.stats;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Map;
import java.util.Set;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.minmax.FlatTreeCreatorLeftSideDirectMinPathLength;
import scj.algorithm.twotrees.labeling.minmax.FlatTreeCreatorRightSideDirectMaxPathLength;
import scj.algorithm.twotrees.labeling.minmax.analysis.MinMaxSearchAnalysisTimeAtFirstLevels;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.CountResultList;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class FBMinMaxHistograms
extends FlatBoth {
    public static void main(String[] args) {
        Executor.EXECUTION_MODE[] eXECUTION_MODEArray = new Executor.EXECUTION_MODE[]{Executor.EXECUTION_MODE.Time};
        int n = eXECUTION_MODEArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executor.EXECUTION_MODE mode = eXECUTION_MODEArray[n2];
            String dataSet = args[0];
            Executor.run(CountResultList.class, dataSet, mode, FBMinMaxHistograms.getBenchmarkAlgorithms(args[1]));
            ++n2;
        }
    }

    public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms(String arg) {
        ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[1];
        FrequencyOrder order = arg.equals("freq") ? new FrequencyOrder() : new InverseFrequencyOrder();
        algorithms[0] = new FBMinMaxHistograms().withSortOrder(order);
        return algorithms;
    }

    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final FlatLeftTreeDirectBuildMinPathLength t1 = rc.measure(new Executable<FlatLeftTreeDirectBuildMinPathLength>(){

            @Override
            public FlatLeftTreeDirectBuildMinPathLength execute() {
                return (FlatLeftTreeDirectBuildMinPathLength)new FlatTreeCreatorLeftSideDirectMinPathLength().getInnerFlatTree(n_a, FBMinMaxHistograms.this.sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>(){

            @Override
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        PIETreeMaxPathLength t2 = rc.measure(new Executable<PIETreeMaxPathLength>(){

            @Override
            public PIETreeMaxPathLength execute() {
                return (PIETreeMaxPathLength)new FlatTreeCreatorRightSideDirectMaxPathLength().getOuterFlatTree(n_b, FBMinMaxHistograms.this.sortOrder);
            }
        }, "build prefix tree 2");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        this.LOGGER.info("{}", (Object)rc);
        new MinMaxSearchAnalysisTimeAtFirstLevels(t1, t2, result).search();
    }

    private Map<Integer, Integer> getFrequencyMapMax(PIETreeMaxPathLength t2) {
        Int2IntOpenHashMap alphabet = new Int2IntOpenHashMap(t2.getSize());
        int i = 0;
        while (i < t2.getSize()) {
            int entry = t2.getMaxPathLengthOf(i);
            if (alphabet.containsKey((Object)entry)) {
                alphabet.put(Integer.valueOf(entry), Integer.valueOf((Integer)alphabet.get((Object)entry) + 1));
            } else {
                alphabet.put(Integer.valueOf(entry), Integer.valueOf(1));
            }
            ++i;
        }
        return alphabet;
    }

    private Map<Integer, Integer> getFrequencyMap(FlatLeftTreeDirectBuildMinPathLength t1) {
        Int2IntOpenHashMap alphabet = new Int2IntOpenHashMap(t1.getSize());
        int i = 0;
        while (i < t1.getSize()) {
            int entry = t1.getMinPathLengthOf(i);
            if (alphabet.containsKey((Object)entry)) {
                alphabet.put(Integer.valueOf(entry), Integer.valueOf((Integer)alphabet.get((Object)entry) + 1));
            } else {
                alphabet.put(Integer.valueOf(entry), Integer.valueOf(1));
            }
            ++i;
        }
        return alphabet;
    }

    private int findTupleSizeOf(int nodeId, FlatLeftTree R) {
        IntList c = R.getChildrenOf(nodeId);
        IntListIterator it = c.iterator();
        int size = R.getIdsByPosition(nodeId).size();
        while (it.hasNext()) {
            int child = it.nextInt();
            size += this.findTupleSizeOf(child, R);
        }
        this.LOGGER.info("tuples\t{}\t{}", (Object)nodeId, (Object)size);
        return size;
    }

    private int findSizeOf(int nodeId, FlatLeftTree R) {
        IntList c = R.getChildrenOf(nodeId);
        IntListIterator it = c.iterator();
        int size = 1;
        while (it.hasNext()) {
            int child = it.nextInt();
            size += this.findSizeOf(child, R);
        }
        this.LOGGER.info("nodes\t{}\t{}", (Object)nodeId, (Object)size);
        return size;
    }

    private void printSizeMapR(FlatLeftTreeDirectBuildMinPathLength t1) {
        this.findSizeOf(0, t1);
        this.findTupleSizeOf(0, t1);
    }

    private void printSizeMapS(PIETreeMaxPathLength t2) {
        int i = 0;
        while (i < t2.getSize()) {
            this.LOGGER.info("nodesS\t{}\t{}", (Object)i, (Object)(t2.getRangeEnd(i) - i + 1));
            this.LOGGER.info("tuplesS\t{}\t{}", (Object)i, (Object)t2.getIdsByPosition(i, t2.getRangeEnd(i)));
            ++i;
        }
    }
}

