/*
 * Decompiled with CFR 0.152.
 */
package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.flat.FlatLeft;
import scj.algorithm.twotrees.labeling.flat.FlatNone;
import scj.algorithm.twotrees.labeling.flat.FlatRight;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class BuildUpModeEvaluation
extends Executor {
    public BuildUpModeEvaluation(RawDataAlgorithm algorithm) {
        super(algorithm);
    }

    public static void main(String[] args) {
        Executor.EXECUTION_MODE[] eXECUTION_MODEArray = new Executor.EXECUTION_MODE[]{Executor.EXECUTION_MODE.Time, Executor.EXECUTION_MODE.Space};
        int n = eXECUTION_MODEArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executor.EXECUTION_MODE mode = eXECUTION_MODEArray[n2];
            String dataSet = args[0];
            BuildUpModeEvaluation.run(CountResultList.class, dataSet, mode, BuildUpModeEvaluation.getBenchmarkAlgorithms());
            ++n2;
        }
    }

    public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
        ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[8];
        FrequencyOrder order = new FrequencyOrder();
        algorithms[0] = new FlatLeft().withSortOrder(order);
        algorithms[1] = new FlatNone().withSortOrder(order);
        algorithms[2] = new FlatRight().withSortOrder(order);
        algorithms[3] = new FlatBoth().withSortOrder(order);
        order = new InverseFrequencyOrder();
        algorithms[4] = new FlatLeft().withSortOrder(order);
        algorithms[5] = new FlatNone().withSortOrder(order);
        algorithms[6] = new FlatRight().withSortOrder(order);
        algorithms[7] = new FlatBoth().withSortOrder(order);
        return algorithms;
    }
}

