/*
 * Decompiled with CFR 0.152.
 */
package scj.evaluation;

import java.util.Set;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.SortOrder;
import scj.algorithm.parallel.DAParallelAlgorithm;
import scj.evaluation.BenchmarkExecutor;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.CountResultList;
import scj.runtime.RuntimeCalculator;

public class ParallelizedBenchmarkExecutor
extends BenchmarkExecutor {
    public ParallelizedBenchmarkExecutor(RawDataAlgorithm algorithm) {
        super(algorithm);
    }

    public static void main(String[] args) {
        Executor.MODE = ParallelizedBenchmarkExecutor.getExecutionMode(args);
        ConfigurableRawDataAlgorithm alg = ParallelizedBenchmarkExecutor.getAlgorithm(args);
        if (!(alg instanceof DAParallelAlgorithm)) {
            System.out.println("Invalid algorithm.");
            System.exit(1);
        }
        DAParallelAlgorithm daAlgorithm = (DAParallelAlgorithm)alg;
        SortOrder order = ParallelizedBenchmarkExecutor.getSortOrder(args);
        daAlgorithm.setSortOrder(order);
        int parallelism = ParallelizedBenchmarkExecutor.getParallelism(args);
        daAlgorithm.setThreads(parallelism);
        ParallelizedBenchmarkExecutor exec = new ParallelizedBenchmarkExecutor(alg);
        CountResultList r = new CountResultList(alg.getClass().getName());
        Set<DataTuple>[] data = ParallelizedBenchmarkExecutor.getExample(args);
        exec.preexecute(data[0], data[1], r);
        RuntimeCalculator rc = new RuntimeCalculator(alg.getClass());
        rc.start("execute");
        exec.execute(data[0], data[1], r);
        rc.stop("execute");
        System.out.println(rc);
    }

    private static ConfigurableRawDataAlgorithm getAlgorithm(String[] args) {
        int argsOffset = 2;
        if (args.length == 2) {
            System.out.println("You have to specify an algorithm.");
            System.exit(1);
        }
        String algorithmName = args[2];
        ConfigurableRawDataAlgorithm algorithm = ParallelizedBenchmarkExecutor.getParallelAlgorithmByName(algorithmName);
        return algorithm;
    }

    protected static Set<DataTuple>[] getExample(String[] args) {
        int argsOffset = 3;
        if (args.length == 3) {
            System.out.println("You have to specify an input file.");
            System.exit(1);
        }
        String dataSetName = args[3];
        int line_limit = -1;
        return ParallelizedBenchmarkExecutor.getInputData(dataSetName, line_limit);
    }

    protected static int getParallelism(String[] args) {
        int argsOffset = 4;
        if (args.length == 4) {
            System.out.println("You have to specify a degree of parallelism.");
            System.exit(1);
        }
        String par = args[4];
        return Integer.parseInt(par);
    }
}

