/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.sa;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.TreeType;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.twotrees.labeling.sa.EncodedSearch;
import scj.algorithm.twotrees.labeling.sa.EncodedTreeCreator;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class LabelingSA
extends ConfigurableRawDataAlgorithm {
    private final Logger LOGGER;
    private SortOrder sortOrder = new InverseFrequencyOrder();

    public LabelingSA() {
        this.LOGGER = LoggerFactory.getLogger(this.toString());
    }

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
    }

    public LabelingSA withSortOrder(SortOrder order) {
        this.setSortOrder(order);
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[order=" + this.sortOrder + "]";
    }

    @Override
    public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        this.sortOrder.initialize(set2);
        for (DataTuple r : set1) {
            this.sortOrder.sort(r.getSet());
        }
        for (DataTuple r : set2) {
            this.sortOrder.sort(r.getSet());
        }
    }

    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        Node t1 = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return new EncodedTreeCreator().createInnerTree(n_a, LabelingSA.this.sortOrder);
            }
        }, "build prefix tree 1");
        final EncodedTreeCreator encodedTreeCreator = new EncodedTreeCreator();
        final Node outerPrefixTree = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return encodedTreeCreator.getPrefixTree(n_b, LabelingSA.this.sortOrder, TreeType.OuterTree);
            }
        }, "build prefix tree 2 - step: prefix tree");
        Node t2 = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return encodedTreeCreator.createOuterTreeFromPrefixTree(outerPrefixTree);
            }
        }, "build prefix tree 2 - step: PIETree");
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            EncodedSearch search = new EncodedSearch(t1, t2, result);
            search.search();
        }
    }
}

