/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.sa;

import java.util.Set;
import scj.algorithm.TreeType;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TTTreeNode;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;
import scj.algorithm.tree.rightside.PIETree;
import scj.input.DataTuple;

public class EncodedTreeCreator {
    public Node createInnerTree(Set<DataTuple> data, SortOrder sortOrder) {
        return this.getPrefixTree(data, sortOrder, TreeType.InnerTree);
    }

    public Node createOuterTreeFromPrefixTree(Node prefixTree) {
        return new PIETree(prefixTree);
    }

    protected Node getPrefixTree(Set<DataTuple> data, SortOrder sortOrder, TreeType type) {
        TreeNode rootNode = this.getTreeNode(-1, type);
        for (DataTuple date : data) {
            Node traverser = rootNode;
            int[] nArray = date.getSet();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int contentElement = nArray[n2];
                Node tmp = traverser.getChild(contentElement);
                if (tmp == null) {
                    tmp = this.getTreeNode(contentElement, type);
                    traverser.addChild(tmp);
                }
                traverser = tmp;
                ++n2;
            }
            traverser.addContent(date.getId());
        }
        if (rootNode instanceof TTTreeNode) {
            ((TTTreeNode)rootNode).postCreate();
        }
        return rootNode;
    }

    protected TreeNode getTreeNode(int contentElement, TreeType type) {
        if (type == TreeType.OuterTree) {
            return new TreeNodeWithIntervalAnnotation(contentElement);
        }
        return new TreeNode(contentElement);
    }
}

