/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.sa;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class EncodedSearch
implements Search {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSearch.class);
    protected Node a;
    protected Result result;
    private PIETree S;

    public EncodedSearch(Node n_a, Node t2, Result result) {
        this.a = n_a;
        this.S = (PIETree)t2;
        this.result = result;
    }

    @Override
    public Result search() {
        this.search(this.a, 0);
        return this.result;
    }

    public String toString() {
        return this.a + "\n" + this.S;
    }

    protected void search(Node n_r, int scope_start) {
        IntList content_r = ((TreeNode)n_r).getTupleIds();
        if (!content_r.isEmpty()) {
            this.lookForOutput(content_r, scope_start);
        }
        for (Node c_r : n_r.getChildren()) {
            IntList result = this.S.findRanges(c_r.getName(), scope_start);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(IntList content_r, int scope_start) {
        IntList result_s = this.S.getIdsByPosition(scope_start, this.S.getRangeEnd(scope_start) + 1);
        IntListIterator it_r = content_r.iterator();
        while (it_r.hasNext()) {
            int nextInt = it_r.nextInt();
            IntIterator it_s = result_s.iterator();
            while (it_s.hasNext()) {
                this.result.add(nextInt, it_s.nextInt());
            }
        }
    }
}

