/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.listrecursion;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class FlatSearchListBasedRecursion
implements Search {
    protected Result result;
    private FlatLeftTree R;
    private PIETree S;

    public FlatSearchListBasedRecursion(FlatLeftTree t1, PIETree t2, Result result) {
        this.R = t1;
        this.S = t2;
        this.result = result;
    }

    @Override
    public Result search() {
        IntArrayList integers = new IntArrayList();
        integers.add(0);
        this.search(0, integers);
        System.out.println(String.valueOf(this.S.recursionTime) + " - " + this.S.scopeTime);
        return this.result;
    }

    public String toString() {
        return this.R + "\n" + this.S;
    }

    protected void search(int r, IntList s) {
        if (s.size() == 0) {
            return;
        }
        this.lookForOutput(r, s);
        Iterator iterator = this.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            this.search(c_r, this.S.findAllRanges(this.R.getNameOf(c_r), s));
        }
    }

    private void lookForOutput(int r, IntList s) {
        IntList content_r = this.R.getIdsByPosition(r);
        if (content_r.isEmpty()) {
            return;
        }
        IntListIterator it_preorder_s = s.iterator();
        while (it_preorder_s.hasNext()) {
            int preorder_s = it_preorder_s.nextInt();
            IntList content_s = this.S.getIdsByPosition(preorder_s, this.S.getRangeEnd(preorder_s) + 1);
            IntIterator it_content_r = content_r.iterator();
            while (it_content_r.hasNext()) {
                int tupleId_r = it_content_r.nextInt();
                IntListIterator it_content_s = content_s.iterator();
                while (it_content_s.hasNext()) {
                    this.result.add(tupleId_r, it_content_s.nextInt());
                }
            }
        }
    }
}

