/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.listrecursion;

import java.util.Set;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorLeftSideDirect;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorRightSideDirect;
import scj.algorithm.twotrees.labeling.listrecursion.FlatSearchListBasedRecursion;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class FlatListBasedRecursion
extends DAAlgorithm {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final FlatLeftTreeDirectBuild t1 = rc.measure(new Executable<FlatLeftTreeDirectBuild>(){

            @Override
            public FlatLeftTreeDirectBuild execute() {
                return new FlatTreeCreatorLeftSideDirect().getInnerFlatTree(n_a, FlatListBasedRecursion.this.sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>(){

            @Override
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        PIETree t2 = rc.measure(new Executable<PIETree>(){

            @Override
            public PIETree execute() {
                return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, FlatListBasedRecursion.this.sortOrder);
            }
        }, "build prefix tree 2");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            FlatSearchListBasedRecursion search = new FlatSearchListBasedRecursion(t1, t2, result);
            search.search();
        }
    }
}

