/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat.semi;

import java.util.Set;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TTTreeNode;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;
import scj.algorithm.tree.leftside.semi.SemiFlatLeftTree;
import scj.algorithm.tree.leftside.semi.SemiFlatLeftTreeFromPrefixTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.input.DataTuple;

public class SemiFlatTreeCreator {
    public PIETree getOuterFlatTree(Node prefixTree) {
        return new PIETree(prefixTree);
    }

    public SemiFlatLeftTree getInnerFlatTree(Node prefixTree) {
        return new SemiFlatLeftTreeFromPrefixTree(prefixTree);
    }

    public Node getPrefixTree(Set<DataTuple> data, SortOrder sortOrder) {
        TreeNode rootNode = this.getTreeNode(-1);
        for (DataTuple date : data) {
            Node traverser = rootNode;
            int[] nArray = date.getSet();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int contentElement = nArray[n2];
                Node tmp = traverser.getChild(contentElement);
                if (tmp == null) {
                    tmp = this.getTreeNode(contentElement);
                    traverser.addChild(tmp);
                }
                traverser = tmp;
                ++n2;
            }
            traverser.addContent(date.getId());
        }
        if (rootNode instanceof TTTreeNode) {
            ((TTTreeNode)rootNode).postCreate();
        }
        return rootNode;
    }

    protected TreeNode getTreeNode(int contentElement) {
        return new TreeNodeWithIntervalAnnotation(contentElement);
    }
}

