/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class FlatSearch
implements Search {
    protected Result result;
    private FlatLeftTree R;
    private PIETree S;

    public FlatSearch(FlatLeftTree t1, PIETree t2, Result result) {
        this.R = t1;
        this.S = t2;
        this.result = result;
    }

    @Override
    public Result search() {
        this.search(0, 0);
        return this.result;
    }

    public String toString() {
        return this.R + "\n" + this.S;
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
        Iterator iterator = this.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            IntList result = this.S.findRanges(this.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntList content_r = this.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.S.getIdsByPosition(s, this.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }
    }
}

