/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.input.DataTuple;
import scj.result.Result;

public abstract class DAAlgorithm
extends ConfigurableRawDataAlgorithm {
    protected SortOrder sortOrder = new InverseFrequencyOrder();
    protected Logger LOGGER = LoggerFactory.getLogger(this.toString());

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
        this.LOGGER = LoggerFactory.getLogger(this.toString());
    }

    public DAAlgorithm withSortOrder(SortOrder order) {
        this.setSortOrder(order);
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "{" + "sortOrder=" + this.sortOrder.toString() + '}';
    }

    @Override
    public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        this.sortOrder.initialize(set2);
        for (DataTuple r : set1) {
            this.sortOrder.sort(r.getSet());
        }
        for (DataTuple r : set2) {
            this.sortOrder.sort(r.getSet());
        }
    }
}

