/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree.rightside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import scj.algorithm.tree.rightside.PIETree;

public class PIETreeMaxPathLength
extends PIETree {
    private IntArrayList maxPathLengths;

    @Override
    public void init(int tupleCount) {
        super.init(tupleCount);
        this.maxPathLengths = new IntArrayList(tupleCount);
    }

    @Override
    public void addRangeEnd(int nodeId, int rangeEndId) {
        super.addRangeEnd(nodeId, rangeEndId);
        if (nodeId == rangeEndId) {
            this.setMaxPathLength(nodeId, 0);
            return;
        }
        int n = nodeId + 1;
        int max = 0;
        while (n <= rangeEndId) {
            int max_path = this.getMaxPathLengthOf(n);
            if (max < max_path) {
                max = max_path;
            }
            n = this.getRangeEnd(n) + 1;
        }
        this.setMaxPathLength(nodeId, max + 1);
    }

    protected void setMaxPathLength(int nodeId, int pathLength) {
        this.maxPathLengths.ensureCapacity(nodeId);
        int i = this.maxPathLengths.size();
        while (i <= nodeId) {
            this.maxPathLengths.add(i, 0);
            ++i;
        }
        this.maxPathLengths.set(nodeId, pathLength);
    }

    public int getMaxPathLengthOf(int nodeId) {
        return this.maxPathLengths.getInt(nodeId);
    }
}

