/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree.rightside;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;

public class PIETree
implements Node {
    Int2ObjectMap<IntList> nameToPreorder;
    IntList rangeEnds;
    int size;
    IntList tupleIdPositions;
    IntList tupleIds;
    public long recursionTime = 0L;
    public long scopeTime = 0L;

    public PIETree() {
        this.size = 0;
    }

    public PIETree(Node prefixTree) {
        this();
        this.readFromTree((TreeNodeWithIntervalAnnotation)prefixTree);
    }

    public PIETree(int tupleCount) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof PIETree) {
            PIETree objPieTree = (PIETree)obj;
            return this.nameToPreorder.equals(objPieTree.nameToPreorder) && this.rangeEnds.equals(objPieTree.rangeEnds) && this.size == objPieTree.size && this.tupleIdPositions.equals(objPieTree.tupleIdPositions) && this.tupleIds.equals(objPieTree.tupleIds);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "PIETree [size=" + this.size + ", nameToPreorder=" + this.nameToPreorder + ", rangeEnds=" + this.rangeEnds + ", tupleIdPositions=" + this.tupleIdPositions + ", tupleIds=" + this.tupleIds + "]";
    }

    @Override
    public Collection<Node> getChildren() {
        return null;
    }

    @Override
    public Node getChild(int contentElement) {
        return null;
    }

    @Override
    public boolean equalsName(Node t2) {
        return false;
    }

    @Override
    public boolean containsTuples() {
        return false;
    }

    @Override
    public boolean greaterThanOrEqualsName(Node c_b) {
        return false;
    }

    @Override
    public int compareTo(Node o) {
        return 0;
    }

    @Override
    public int getName() {
        return 0;
    }

    @Override
    public Collection<Integer> getTupleIds() {
        return null;
    }

    @Override
    public void addChild(Node node) {
    }

    @Override
    public void addContent(int i) {
    }

    public int getSize() {
        return this.size;
    }

    public IntList getIdsByPosition(int scope_start, int scope_end) {
        int end = scope_end < this.tupleIdPositions.size() ? this.tupleIdPositions.getInt(scope_end) : this.tupleIds.size();
        return this.tupleIds.subList(this.tupleIdPositions.getInt(scope_start), end);
    }

    public int getRangeEnd(int scope_start) {
        return this.rangeEnds.getInt(scope_start);
    }

    public IntList findRanges(int name, int scope_start) {
        return this.limitToRangeBinary(this.getRangeListByName(name), scope_start, this.getRangeEnd(scope_start));
    }

    public IntList findAllRanges(int name, IntList scopes) {
        return this.limitToRangeBinary(this.getRangeListByName(name), scopes);
    }

    public IntList getRangeListByName(int name) {
        IntList integers = (IntList)this.nameToPreorder.get(name);
        if (integers != null) {
            return integers;
        }
        return new IntArrayList();
    }

    public IntList limitToRangeBinary(IntList rangeList, int scope_start, int scope_end) {
        int m;
        if (rangeList.size() == 0 || rangeList.getInt(0) > scope_end || rangeList.getInt(rangeList.size() - 1) < scope_start) {
            return new IntArrayList();
        }
        int a = 0;
        int b = rangeList.size();
        int a_2 = -1;
        int b_2 = -1;
        while (a < b) {
            m = a + b >>> 1;
            if (rangeList.getInt(m) < scope_start) {
                a = m + 1;
                continue;
            }
            if (a_2 == -1 && rangeList.getInt(m) <= scope_end) {
                a_2 = m;
                b_2 = b;
            }
            b = m;
        }
        if (a_2 != -1) {
            while (a_2 < b_2) {
                m = a_2 + b_2 >>> 1;
                if (rangeList.getInt(m) <= scope_end) {
                    a_2 = m + 1;
                    continue;
                }
                b_2 = m;
            }
        } else {
            a_2 = a;
            if (rangeList.getInt(a) == scope_end) {
                ++a_2;
            }
        }
        return new IntArrayList(rangeList.subList(a, a_2));
    }

    protected void readFromTree(TreeNodeWithIntervalAnnotation prefixTree) {
        this.decorateWithIntervals(prefixTree, 0);
        this.size = prefixTree.getI2();
        this.tupleIdPositions = new IntArrayList(this.size);
        this.tupleIds = new IntArrayList();
        this.nameToPreorder = new Int2ObjectOpenHashMap<IntList>();
        this.rangeEnds = new IntArrayList(this.size);
        this.pickIntervalsAndTupleIDs(prefixTree);
    }

    private int decorateWithIntervals(TreeNodeWithIntervalAnnotation prefixTree, int i) {
        prefixTree.setI1(i);
        for (Node child : prefixTree.getChildren()) {
            i = this.decorateWithIntervals((TreeNodeWithIntervalAnnotation)child, i + 1);
        }
        prefixTree.setI2(i);
        return i;
    }

    private void pickIntervalsAndTupleIDs(TreeNodeWithIntervalAnnotation prefixTree) {
        int i1 = prefixTree.getI1();
        this.rangeEnds.add(i1, prefixTree.getI2());
        int name = prefixTree.getName();
        this.putNameToPreorder(name, i1);
        this.tupleIdPositions.add(i1, this.tupleIds.size());
        this.tupleIds.addAll(prefixTree.getTupleIds());
        for (Node child : prefixTree.getChildren()) {
            this.pickIntervalsAndTupleIDs((TreeNodeWithIntervalAnnotation)child);
        }
    }

    protected void putNameToPreorder(int name, int preorder) {
        if (this.nameToPreorder.containsKey(name)) {
            ((IntList)this.nameToPreorder.get(name)).add(preorder);
        } else {
            IntArrayList list = new IntArrayList();
            list.add(preorder);
            this.nameToPreorder.put(name, (IntList)list);
        }
    }

    public void init(int tupleCount) {
        int sizeEstimation = tupleCount;
        this.tupleIdPositions = new IntArrayList(sizeEstimation);
        this.tupleIds = new IntArrayList(tupleCount);
        this.nameToPreorder = new Int2ObjectOpenHashMap<IntList>();
        this.rangeEnds = new IntArrayList(sizeEstimation);
        this.size = 0;
    }

    public void addRangeEnd(int nodeId, int rangeEndId) {
        if (nodeId > this.size) {
            this.size = nodeId;
        }
        while (this.rangeEnds.size() < nodeId) {
            this.rangeEnds.add(this.rangeEnds.size(), 0);
        }
        if (this.rangeEnds.size() != nodeId) {
            this.rangeEnds.remove(nodeId);
        }
        this.rangeEnds.add(nodeId, rangeEndId);
    }

    public void addNameToPreorder(int name, int nodeId) {
        this.putNameToPreorder(name, nodeId);
    }

    public void addPreorderToContent(int nodeId, int tupleId) {
        int previousListSize = this.tupleIdPositions.size();
        int tupleCount = this.tupleIds.size();
        while (this.tupleIdPositions.size() < nodeId) {
            this.tupleIdPositions.add(previousListSize, tupleCount);
        }
        if (this.tupleIdPositions.size() == nodeId) {
            this.tupleIdPositions.add(nodeId, tupleCount);
        }
        this.tupleIds.add(tupleId);
    }

    public IntList limitToRangeBinary(IntList rangeList, IntList scopes) {
        long tmp = System.currentTimeMillis();
        IntList recurse = this.recurse(rangeList, scopes);
        this.recursionTime += System.currentTimeMillis() - tmp;
        if (recurse == null) {
            return new IntArrayList(0);
        }
        return recurse;
    }

    private IntList recurse(IntList values, IntList scopes) {
        if (values.size() == 0) {
            return values;
        }
        if (scopes.size() == 0) {
            return null;
        }
        if (values.getInt(0) > this.getRangeEnd(scopes.getInt(scopes.size() - 1))) {
            return null;
        }
        if (values.getInt(values.size() - 1) < scopes.getInt(0)) {
            return null;
        }
        if (scopes.size() == 1 && scopes.getInt(0) <= values.getInt(0) && this.getRangeEnd(scopes.getInt(0)) >= values.getInt(values.size() - 1)) {
            return values;
        }
        if (values.size() == 1) {
            return this.isValueInAScope(values.getInt(0), scopes) ? values : null;
        }
        int m = 0 + values.size() >>> 1;
        int needle = values.getInt(m);
        long tmp = System.currentTimeMillis();
        int separatorIdx = this.getSeparator(scopes, needle) - 1;
        IntList scopesBelow = scopes.subList(0, separatorIdx + 1);
        IntList scopesAbove = separatorIdx >= 0 && this.getRangeEnd(scopes.getInt(separatorIdx)) >= needle ? scopes.subList(separatorIdx, scopes.size()) : scopes.subList(separatorIdx + 1, scopes.size());
        this.scopeTime += System.currentTimeMillis() - tmp;
        IntList result = this.recurse(values.subList(0, m), scopesBelow);
        IntList x = this.recurse(values.subList(m, values.size()), scopesAbove);
        if (result == null && x != null) {
            result = x;
        } else if (result != null & x != null) {
            result = new IntArrayList(result);
            result.addAll(x);
        }
        return result;
    }

    private boolean isValueInAScope(int value, IntList scopes) {
        int scopeStartM;
        int l = 0;
        int r = scopes.size();
        int m = 0;
        while (l < r) {
            m = (r + l) / 2;
            scopeStartM = scopes.getInt(m);
            if (value >= scopeStartM && value <= this.getRangeEnd(scopeStartM)) {
                return true;
            }
            if (value > scopeStartM) {
                l = m + 1;
                continue;
            }
            if (value >= scopeStartM) continue;
            r = m - 1;
        }
        scopeStartM = scopes.getInt(l);
        return value >= scopeStartM && value <= this.getRangeEnd(scopeStartM);
    }

    public int getSeparator(IntList scopes, int needle) {
        int scopesSize = scopes.size();
        int l = 0;
        int r = scopesSize;
        while (l < r) {
            int m = (r + l) / 2;
            int intAtM = scopes.getInt(m);
            if (needle == intAtM) {
                return m;
            }
            if (needle > intAtM) {
                if (m + 1 < scopesSize && scopes.getInt(m + 1) > needle) {
                    return m + 1;
                }
                l = m + 1;
                continue;
            }
            if (needle >= intAtM) continue;
            r = m - 1;
        }
        if (r + 1 < scopesSize) {
            return r + 1;
        }
        return r;
    }
}

