/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree.leftside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;
import scj.algorithm.tree.leftside.FlatLeftTree;

public class FlatLeftTreeFromPrefixTree
extends FlatLeftTree {
    public FlatLeftTreeFromPrefixTree(Node prefixTree) {
        this.size = 0;
        this.readFromTree((TreeNodeWithIntervalAnnotation)prefixTree);
    }

    private void readFromTree(TreeNodeWithIntervalAnnotation prefixTree) {
        this.decorateWithIntervals(prefixTree, 0);
        this.size = prefixTree.getI2();
        this.tupleIdPositions = new IntArrayList(this.size);
        this.tupleIds = new IntArrayList();
        this.childrenPositions = new IntArrayList(this.size);
        this.children = new IntArrayList();
        this.nodeNames = new IntArrayList(this.size);
        this.pickIntervals(prefixTree);
    }

    private int decorateWithIntervals(TreeNodeWithIntervalAnnotation prefixTree, int i) {
        prefixTree.setI1(i);
        for (Node child : prefixTree.getChildren()) {
            i = this.decorateWithIntervals((TreeNodeWithIntervalAnnotation)child, i + 1);
        }
        prefixTree.setI2(i);
        return i;
    }

    private void pickIntervals(TreeNodeWithIntervalAnnotation prefixTree) {
        this.nodeNames.add(prefixTree.getI1(), prefixTree.getName());
        this.tupleIdPositions.add(prefixTree.getI1(), this.tupleIds.size());
        this.tupleIds.addAll(prefixTree.getTupleIds());
        this.childrenPositions.add(prefixTree.getI1(), this.children.size());
        Collection<Node> children = prefixTree.getChildren();
        for (Node child : children) {
            this.children.add(((TreeNodeWithIntervalAnnotation)child).getI1());
        }
        for (Node child : children) {
            this.pickIntervals((TreeNodeWithIntervalAnnotation)child);
        }
    }
}

