/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree.leftside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import scj.algorithm.tree.leftside.FlatLeftTree;

public class FlatLeftTreeDirectBuild
extends FlatLeftTree {
    protected ObjectList<IntArrayList> childrenVertical;

    public FlatLeftTreeDirectBuild(int tupleCount) {
        int estNodeCnt = tupleCount;
        this.size = 1;
        this.tupleIdPositions = new IntArrayList(estNodeCnt);
        this.tupleIds = new IntArrayList(tupleCount);
        this.childrenPositions = new IntArrayList(estNodeCnt);
        this.children = new IntArrayList(estNodeCnt);
        this.childrenVertical = new ObjectArrayList<IntArrayList>(estNodeCnt);
        this.nodeNames = new IntArrayList(estNodeCnt);
        this.tupleIdPositions.add(0);
        this.childrenVertical.add(0, null);
        this.nodeNames.add(-1);
    }

    public int addNode(int position, int name) {
        int newNodeId = this.size++;
        this.nodeNames.add(newNodeId, name);
        this.addChildRelation(position, newNodeId);
        this.tupleIdPositions.add(newNodeId, this.tupleIds.size());
        this.childrenVertical.add(newNodeId, null);
        return newNodeId;
    }

    private void addChildRelation(int parentId, int childId) {
        IntArrayList vertical = (IntArrayList)this.childrenVertical.get(parentId);
        if (vertical == null) {
            vertical = new IntArrayList(2);
        }
        vertical.add(childId);
        this.childrenVertical.set(parentId, vertical);
    }

    public void complete() {
        this.transformChildrenData();
        this.unsetChildrenVerticalData();
    }

    public void unsetChildrenVerticalData() {
        this.childrenVertical = null;
    }

    public void transformChildrenData() {
        int offset = 0;
        this.childrenPositions.ensureCapacity(this.size);
        int i = 0;
        while (i < this.size) {
            this.childrenPositions.add(offset);
            IntArrayList vertical = (IntArrayList)this.childrenVertical.get(i);
            if (vertical != null) {
                this.children.addAll(vertical);
                offset += vertical.size();
            }
            ++i;
        }
    }

    public void addTupleToNode(int node, int tupleId) {
        this.insertIntoSkipList(this.tupleIdPositions, this.tupleIds, node, tupleId);
    }

    protected void insertIntoSkipList(IntList positionList, IntList valueList, int position, int value) {
        if (position + 1 == positionList.size()) {
            valueList.add(value);
        } else {
            int insertIndex = (Integer)positionList.get(position + 1);
            valueList.add(insertIndex, value);
            int i = position + 1;
            while (i < positionList.size()) {
                positionList.set(i, (Integer)positionList.get(i) + 1);
                ++i;
            }
        }
    }
}

