/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree;

import gnu.trove.list.linked.TIntLinkedList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import scj.algorithm.tree.LinkedNode;

public class LinkedTreeNode
implements LinkedNode {
    public static final int DEFAULT_VALUE = -1;
    protected int name;
    protected TIntLinkedList tupleIds;
    protected Int2ObjectMap<LinkedNode> children;

    public LinkedTreeNode(int contentElement) {
        this.name = contentElement;
        this.tupleIds = new TIntLinkedList();
        this.children = new Int2ObjectOpenHashMap<LinkedNode>();
    }

    public String toString() {
        throw new IllegalStateException("Do not call me!");
    }

    @Override
    public int getName() {
        return this.name;
    }

    @Override
    public boolean equalsName(LinkedNode t2) {
        return this.getName() == t2.getName();
    }

    @Override
    public boolean greaterThanOrEqualsName(LinkedNode t2) {
        return this.getName() >= t2.getName();
    }

    @Override
    public void addContent(int tuple) {
        this.tupleIds.add(tuple);
    }

    @Override
    public TIntLinkedList getTupleIds() {
        return this.tupleIds;
    }

    @Override
    public boolean containsTuples() {
        return !this.tupleIds.isEmpty();
    }

    @Override
    public void addChild(LinkedNode node) {
        this.children.put(node.getName(), node);
    }

    @Override
    public Collection<LinkedNode> getChildren() {
        return this.children.values();
    }

    @Override
    public LinkedNode getChild(int childName) {
        if (this.children.containsKey(childName)) {
            return (LinkedNode)this.children.get(childName);
        }
        return null;
    }

    @Override
    public int compareTo(LinkedNode o) {
        return Integer.compare(this.name, o.getName());
    }
}

