/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.pretti;

import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import scj.input.DataTuple;

public class PrettiInvertedIndex {
    private static final TIntArrayList EMPTY_LIST = new TIntArrayList();
    protected Map<Integer, TIntArrayList> index = new Int2ObjectOpenHashMap<TIntArrayList>();

    public PrettiInvertedIndex(Set<DataTuple> set2) {
        this.fillIndex(set2);
    }

    protected void fillIndex(Set<DataTuple> set2) {
        for (DataTuple tuple : set2) {
            int[] nArray = tuple.getSet();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int name = nArray[n2];
                if (!this.index.containsKey(name)) {
                    this.index.put(name, new TIntArrayList());
                }
                this.index.get(name).add(tuple.getId());
                ++n2;
            }
        }
        for (TIntArrayList tupleIdList : this.index.values()) {
            tupleIdList.sort();
        }
    }

    public int getSize() {
        return this.index.keySet().size();
    }

    public TIntArrayList get(int i) {
        if (this.index.containsKey(i)) {
            return this.index.get(i);
        }
        return EMPTY_LIST;
    }

    public String toString() {
        return "Inverted index: " + this.index.toString();
    }
}

