/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.rangetask;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.rangetask.FlatRangeSearchParallelization;
import scj.algorithm.parallel.rangetask.L1RangeTaskSearch;
import scj.algorithm.parallel.rangetask.SearchRangeTask;
import scj.result.Result;

public class SearchRangeTaskWholeTree
implements SearchRangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRangeTaskWholeTree.class);
    private FlatRangeSearchParallelization search;
    private int r;
    private Result result;

    @Override
    public void set(L1RangeTaskSearch onePairSearch, int rangeStart) {
        this.search = onePairSearch;
        this.r = rangeStart;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        long tmpTime = System.currentTimeMillis();
        this.search(this.r);
        tmpTime = System.currentTimeMillis() - tmpTime;
        this.search.result.add(this.result);
        this.search.informFinished(this);
        LOGGER.info("{}\t{} ms", (Object)this.r, (Object)tmpTime);
    }

    private void search(int rangeStart) {
        IntList childrenR = this.search.R.getChildrenOf(0);
        int i = 0;
        while (i + rangeStart < childrenR.size() && i < L1RangeTaskSearch.getRangeSize()) {
            int r = childrenR.getInt(i + rangeStart);
            int nameOf = this.search.R.getNameOf(r);
            this.search(r, 0, nameOf);
            ++i;
        }
    }

    protected void search(int r, int s, int name) {
        IntList result = this.search.S.findRanges(name, s);
        IntListIterator resultItr = result.iterator();
        while (resultItr.hasNext()) {
            this.search(r, resultItr.nextInt());
        }
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
        Iterator iterator = this.search.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            IntList result = this.search.S.findRanges(this.search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }
    }
}

