/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.listtask;

import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.listtask.FlatListSearchParallelization;
import scj.algorithm.parallel.listtask.SearchListTask;
import scj.algorithm.parallel.listtask.SearchListTaskOneTask;
import scj.algorithm.parallel.listtask.SearchListTaskWholeTree;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;

public class L1ListTaskSearch
extends FlatListSearchParallelization {
    private static final Logger LOGGER = LoggerFactory.getLogger(L1ListTaskSearch.class);

    public L1ListTaskSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
        super(t2, result, t1, threads);
    }

    @Override
    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<SearchListTask>(new PoolableObjectBase<SearchListTask>(){

            @Override
            public SearchListTask make() {
                return new SearchListTaskWholeTree();
            }

            @Override
            public void activate(SearchListTask t) {
            }
        });
    }

    @Override
    public void addNewSearch(int r, int s, int name) {
        try {
            SearchTask task;
            if (r == 0 && s == 0) {
                task = new SearchListTaskOneTask(this, r, s);
            } else {
                task = (SearchTask)this.objectPool.getObj();
                ((SearchListTask)task).set(this, r, name);
            }
            this.numberOfTasks.incrementAndGet();
            this.threadPool.execute(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

