/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.listtask;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nf.fr.eraasoft.pool.ObjectPool;
import nf.fr.eraasoft.pool.PoolSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.LoggingQueue;
import scj.algorithm.parallel.ThreadPoolExecutorWithObjectPool;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public abstract class FlatListSearchParallelization
implements Search {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatListSearchParallelization.class);
    protected int nThreads = 16;
    public Result result;
    public FlatLeftTree R;
    public PIETree S;
    protected ObjectPool<? extends SearchTask> objectPool;
    private final PoolSettings<? extends SearchTask> poolSettings;
    public ThreadPoolExecutorWithObjectPool threadPool;
    protected AtomicInteger numberOfTasks = new AtomicInteger(0);

    public void setThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public FlatListSearchParallelization(PIETree t2, Result result, FlatLeftTree t1, int threads) {
        this.S = t2;
        this.result = result;
        this.R = t1;
        this.setThreads(this.nThreads);
        this.threadPool = this.getThreadPoolExecutor();
        this.poolSettings = this.getSearchTaskPoolSettings();
        this.poolSettings.min(0).max(-1).validateWhenReturn(false);
        this.objectPool = this.poolSettings.pool();
        this.threadPool.setObjectPool(this.objectPool);
    }

    public ThreadPoolExecutorWithObjectPool getThreadPoolExecutor() {
        return new ThreadPoolExecutorWithObjectPool(this.nThreads, this.nThreads, 0L, TimeUnit.MILLISECONDS, new LoggingQueue<Runnable>(this.nThreads));
    }

    @Override
    public Result search() {
        this.addNewSearch(0, 0, 0);
        while (this.numberOfTasks.get() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(10L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOGGER.info("Final pool status: {}", (Object)this.threadPool.toString());
        PoolSettings.shutdown();
        return this.result;
    }

    protected abstract PoolSettings<? extends SearchTask> getSearchTaskPoolSettings();

    public abstract void addNewSearch(int var1, int var2, int var3);

    public String toString() {
        return this.R + "\n" + this.S;
    }

    public void informFinished(SearchTask searchTaskOnePair) {
        this.numberOfTasks.decrementAndGet();
    }
}

