/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.AdaptiveRangingSearch;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedRangeTask;

public class PrioritizedInitTask
implements PrioritizedRangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritizedInitTask.class);
    public static int RANGE_SIZE;
    protected AdaptiveRangingSearch search;

    public String toString() {
        return "SplittingTask{}";
    }

    public PrioritizedInitTask(AdaptiveRangingSearch l1RangeTaskSearch) {
        this.search = l1RangeTaskSearch;
        RANGE_SIZE = Integer.valueOf(System.getProperty("rangeSize", "5"));
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        this.splitAndStartSearches();
        this.search(0, 0);
        LOGGER.info("Init ready.");
        this.search.informFinished(this);
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
    }

    private void splitAndStartSearches() {
        IntList childrenR = this.search.R.getChildrenOf(0);
        int idealRangeSize = this.getIdealRangeSize(this.search.getOverallItemCount());
        int rangeStart = 0;
        int rangeFreqSum = 0;
        IntArrayList l = new IntArrayList();
        l.add(0);
        int i = 0;
        while (i < childrenR.size()) {
            int freq;
            int childNodeId = childrenR.getInt(i);
            int childNodeName = this.search.R.getNameOf(childNodeId);
            IntList rangeStartsS = this.search.S.findRanges(childNodeName, 0);
            int n = freq = this.search.getFrequencyMap().containsKey(childNodeName) ? this.search.getFrequencyMap().get(childNodeName) : 1;
            if (rangeFreqSum + freq < idealRangeSize) {
                rangeFreqSum += freq;
            } else if (rangeStart == i) {
                LOGGER.info("Split node {} (name: {}), has size {} (> optimum of {})", childNodeId, childNodeName, freq, idealRangeSize);
                this.search.addNewSplitting(childNodeId, rangeStartsS);
                rangeFreqSum = 0;
                rangeStart = i + 1;
            } else {
                this.search.addNewSearch(0, rangeStart, i - 1, l);
                rangeFreqSum = freq;
                rangeStart = i;
            }
            ++i;
        }
        if (rangeStart != childrenR.size() && childrenR.size() > 0) {
            this.search.addNewSearch(0, rangeStart, childrenR.size() - 1, l);
        }
    }

    public int getIdealRangeSize(int overallItemCount) {
        int estimatedBestExecutorCount = this.search.nThreads * RANGE_SIZE;
        int rangeSize = overallItemCount / estimatedBestExecutorCount;
        if (rangeSize < 1) {
            rangeSize = 1;
        }
        return rangeSize;
    }

    protected void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    int nextInt1 = it_s.nextInt();
                    this.search.result.add(nextInt, nextInt1);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

