/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import java.util.Set;
import scj.algorithm.parallel.DAParallelAlgorithm;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.AdaptiveRangeSearchParallelization;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.AdaptiveRangingSearch;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorLeftSideDirect;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorRightSideDirect;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class AdaptiveRangingWithPriority
extends DAParallelAlgorithm {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final FlatLeftTreeDirectBuild t1 = rc.measure(new Executable<FlatLeftTreeDirectBuild>(){

            @Override
            public FlatLeftTreeDirectBuild execute() {
                return new FlatTreeCreatorLeftSideDirect().getInnerFlatTree(n_a, AdaptiveRangingWithPriority.this.sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>(){

            @Override
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        PIETree t2 = rc.measure(new Executable<PIETree>(){

            @Override
            public PIETree execute() {
                return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, AdaptiveRangingWithPriority.this.sortOrder);
            }
        }, "build prefix tree 2");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        Map<Integer, Integer> frequencyMap = rc.measure(new Executable<Map<Integer, Integer>>(){

            @Override
            public Map<Integer, Integer> execute() {
                AdaptiveRangingWithPriority.this.sortOrder.initialize(n_b);
                return AdaptiveRangingWithPriority.this.sortOrder.getFrequencyMap();
            }
        }, "build frequency map");
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            AdaptiveRangingSearch search = new AdaptiveRangingSearch(t1, t2, result, this.getThreads());
            search.setFrequencyMap(frequencyMap);
            int overallItemCount = this.overallItemCount(search);
            this.LOGGER.info("overall item overallItemCount: {}", (Object)overallItemCount);
            search.setOverallItemCount(overallItemCount);
            search.search();
            result.output();
        }
    }

    protected int overallItemCount(AdaptiveRangeSearchParallelization search) {
        IntList childrenR = search.R.getChildrenOf(0);
        int sum = 0;
        int i = 0;
        while (i < childrenR.size()) {
            int r = childrenR.getInt(i);
            int nameOf = search.R.getNameOf(r);
            Integer f = 0;
            if (search.getFrequencyMap() != null && search.getFrequencyMap().containsKey(nameOf)) {
                f = search.getFrequencyMap().get(nameOf);
            }
            sum += f.intValue();
            ++i;
        }
        return sum;
    }
}

