/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntList;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObjectBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.AdaptiveRangeSearchParallelization;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedInitTask;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedRangeTask;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedRangeTaskWholeTree;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedSplittingTask;
import scj.algorithm.parallel.nodetask.SearchTask;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.result.Result;

public class AdaptiveRangingSearch
extends AdaptiveRangeSearchParallelization {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveRangingSearch.class);

    public AdaptiveRangingSearch(FlatLeftTree t1, PIETree t2, Result result, int threads) {
        super(t2, result, t1, threads);
    }

    @Override
    public PoolSettings<? extends SearchTask> getSearchTaskPoolSettings() {
        return new PoolSettings<PrioritizedRangeTask>(new PoolableObjectBase<PrioritizedRangeTask>(){

            @Override
            public PrioritizedRangeTask make() {
                return new PrioritizedRangeTaskWholeTree();
            }

            @Override
            public void activate(PrioritizedRangeTask t) {
            }
        });
    }

    @Override
    public void addNewSearchInit() {
        try {
            PrioritizedInitTask task = new PrioritizedInitTask(this);
            this.numberOfTasks.incrementAndGet();
            this.threadPool.execute(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void addNewSplitting(int nodeId, IntList matchingRangeStartsS) {
        try {
            PrioritizedSplittingTask task = new PrioritizedSplittingTask(this, nodeId, matchingRangeStartsS);
            this.numberOfTasks.incrementAndGet();
            this.threadPool.execute(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void addNewSearch(int nodeId, int rangeStart, int rangeEnd, IntList rangeStartsS) {
        try {
            SearchTask task = (SearchTask)this.objectPool.getObj();
            ((PrioritizedRangeTaskWholeTree)task).set(this, nodeId, rangeStart, rangeEnd, rangeStartsS);
            this.numberOfTasks.incrementAndGet();
            this.threadPool.execute(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

