/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.adaptiveranging.AdaptiveRangingSearch;
import scj.algorithm.parallel.adaptiveranging.RangeTask;
import scj.result.Result;

public class SplittingTask
implements RangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplittingTask.class);
    public static final int RANGE_SIZE = 10;
    private final Result result;
    private int nodeId;
    private IntList rangeStartsS;
    protected AdaptiveRangingSearch search;

    public String toString() {
        return "SplittingTask{}";
    }

    public SplittingTask(AdaptiveRangingSearch adaptiveRangingSearch, int nodeId, IntList matchingRangeStartsS) {
        this.search = adaptiveRangingSearch;
        this.nodeId = nodeId;
        this.rangeStartsS = matchingRangeStartsS;
        this.result = adaptiveRangingSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.splitAndStartSearches(this.nodeId);
        long tmpTime = System.currentTimeMillis() - startTime;
        this.search(this.nodeId, this.rangeStartsS);
        this.search.result.add(this.result);
        startTime = System.currentTimeMillis() - startTime;
        this.search.informFinished(this);
        LOGGER.info("Splitting: node {}\t {} ms + {} ms", this.nodeId, startTime, tmpTime);
    }

    protected void search(int nodeId, IntList rangeStartsS) {
        IntListIterator resultItr = rangeStartsS.iterator();
        while (resultItr.hasNext()) {
            this.lookForOutput(nodeId, resultItr.nextInt());
        }
    }

    private void splitAndStartSearches(int nodeId) {
        IntList childrenR = this.search.R.getChildrenOf(nodeId);
        int idealRangeSize = this.getIdealRangeSize(this.search.getOverallItemCount());
        int rangeStart = 0;
        int rangeFreqSum = 0;
        LOGGER.info("{}: {} child nodes", (Object)nodeId, (Object)childrenR.size());
        int i = 0;
        while (i < childrenR.size()) {
            int freq;
            int childNodeId = childrenR.getInt(i);
            int childNodeName = this.search.R.getNameOf(childNodeId);
            int n = freq = this.search.getFrequencyMap().containsKey(childNodeName) ? this.search.getFrequencyMap().get(childNodeName) : 1;
            if (rangeFreqSum + freq < idealRangeSize) {
                rangeFreqSum += freq;
            } else if (rangeStart == i) {
                this.search.addNewSearch(nodeId, rangeStart, i, this.rangeStartsS);
                rangeFreqSum = freq;
                rangeStart = i + 1;
            } else {
                this.search.addNewSearch(nodeId, rangeStart, i - 1, this.rangeStartsS);
                rangeFreqSum = freq;
                rangeStart = i;
            }
            ++i;
        }
        if (rangeStart != childrenR.size()) {
            this.search.addNewSearch(nodeId, rangeStart, childrenR.size() - 1, this.rangeStartsS);
        }
    }

    public int getIdealRangeSize(int overallItemCount) {
        int estimatedBestExecutorCount = this.search.nThreads * 5;
        int rangeSize = overallItemCount / estimatedBestExecutorCount;
        if (rangeSize < 1) {
            rangeSize = 1;
        }
        return rangeSize;
    }

    protected void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    int nextInt1 = it_s.nextInt();
                    this.result.add(nextInt, nextInt1);
                }
            }
        }
    }
}

