/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.limitremade.structures;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;

public class LIMITAPrefixTreeNode
extends TreeNode {
    private static final long serialVersionUID = -7050432969140113983L;
    protected IntList cutOffTuples = new IntArrayList();
    protected int recsInSubtreeCnt = 0;
    protected int depth;

    public LIMITAPrefixTreeNode(int name, int depth) {
        super(name);
        this.depth = depth;
    }

    public void increaseRecCnt() {
        ++this.recsInSubtreeCnt;
    }

    public int getDepth() {
        return this.depth;
    }

    public void printChildren() {
        System.out.println("this: " + this.getName());
        for (Node c : this.getChildren()) {
            System.out.println("\t" + c.getName());
        }
    }

    public int getRecsInSubtreeCnt() {
        return this.recsInSubtreeCnt;
    }

    public int getSize() {
        int size = 0;
        for (Node child : this.getChildren()) {
            ++size;
            size += ((LIMITAPrefixTreeNode)child).getSize();
        }
        return size;
    }

    public int getCutOffCnt() {
        int cnt = this.cutOffTuples.size();
        for (Node child : this.getChildren()) {
            cnt += ((LIMITAPrefixTreeNode)child).getCutOffCnt();
        }
        return cnt;
    }

    public int getRecordCnt() {
        int cnt = this.tupleIds.size();
        for (Node child : this.getChildren()) {
            cnt += ((LIMITAPrefixTreeNode)child).getRecordCnt();
        }
        return cnt;
    }

    public IntList getCutOffTuples() {
        return this.cutOffTuples;
    }

    public void addCutOffTuple(int tup) {
        this.cutOffTuples.add(tup);
    }

    @Override
    public boolean containsTuples() {
        return !this.tupleIds.isEmpty();
    }

    public boolean containsCutOffs() {
        return !this.cutOffTuples.isEmpty();
    }
}

