/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.limitcomplete;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.limitremade.structures.LIMITAPrefixTree;
import scj.algorithm.limitremade.structures.LIMITAPrefixTreeNode;
import scj.algorithm.limitremade.structures.LIMITOPJInvertedIndex;
import scj.algorithm.limitremade.structures.TupleIDList;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class LIMITOPJINDEXING
extends ConfigurableRawDataAlgorithm
implements RawDataAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(LIMITOPJINDEXING.class);
    SortOrder sortOrder;
    static final int SORT_ASC = 0;
    static final int SORT_DESC = 1;
    int sOrder;
    static int limit = 4;
    int[][] rdArray;
    int[][] sdArray;
    long myresult;

    public LIMITOPJINDEXING(int limit, String so) {
        LIMITOPJINDEXING.limit = limit;
        if (so.equals("ASC")) {
            this.sOrder = 0;
            this.sortOrder = new InverseFrequencyOrder();
        } else if (so.equals("DESC")) {
            this.sOrder = 1;
            this.sortOrder = new FrequencyOrder();
        }
        this.myresult = 0L;
    }

    @Override
    public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        int[] dtSet;
        this.sortOrder.initialize(set1);
        for (DataTuple r : set1) {
            r.setSet(this.sortOrder.sort(r.getSet()));
        }
        this.sortOrder.initialize(set2);
        for (DataTuple r : set2) {
            r.setSet(this.sortOrder.sort(r.getSet()));
        }
        this.rdArray = new int[set1.size() + 1][];
        for (DataTuple dt : set1) {
            dtSet = dt.getSet();
            this.rdArray[dt.getId()] = dtSet;
        }
        this.sdArray = new int[set2.size() + 1][];
        for (DataTuple dt : set2) {
            dtSet = dt.getSet();
            this.sdArray[dt.getId()] = dtSet;
        }
    }

    public int[] sortRelation(int[][] dataArray) {
        int[] oldIndices = new int[dataArray.length];
        int i = 1;
        while (i < oldIndices.length) {
            oldIndices[i] = i;
            ++i;
        }
        this.sortRelationRec(dataArray, oldIndices, 1, dataArray.length - 1);
        return oldIndices;
    }

    public void sortRelationRec(int[][] dataArray, int[] oldIndices, int left, int right) {
        if (left >= right) {
            return;
        }
        this.swap(dataArray, oldIndices, left, (left + right) / 2);
        int last = left;
        int i = left + 1;
        while (i <= right) {
            int diff = this.sOrder == 0 ? dataArray[i][0] - dataArray[left][0] : dataArray[left][0] - dataArray[i][0];
            int ldiff = dataArray[i].length - dataArray[left].length;
            if (diff > 0 || diff == 0 && (ldiff < 0 || ldiff == 0 && oldIndices[i] < oldIndices[left])) {
                this.swap(dataArray, oldIndices, ++last, i);
            }
            ++i;
        }
        this.swap(dataArray, oldIndices, left, last);
        this.sortRelationRec(dataArray, oldIndices, left, last - 1);
        this.sortRelationRec(dataArray, oldIndices, last + 1, right);
    }

    private void swap(int[][] dataArray, int[] oldIndices, int left, int right) {
        int oldLeft = oldIndices[left];
        int[] tData = dataArray[left];
        dataArray[left] = dataArray[right];
        oldIndices[left] = oldIndices[right];
        dataArray[right] = tData;
        oldIndices[right] = oldLeft;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        block9: {
            block8: {
                rc = new RuntimeCalculator(this.getClass());
                rArray = this.rdArray;
                sArray = this.sdArray;
                rc.measure(new Executable(){

                    public Object execute() {
                        return LIMITOPJINDEXING.this.rdArray;
                    }
                }, "R array");
                rc.measure(new Executable(){

                    public Object execute() {
                        return LIMITOPJINDEXING.this.sdArray;
                    }
                }, "S array");
                tr = (LIMITAPrefixTree)rc.measure(new Executable(){

                    public Object execute() {
                        return new LIMITAPrefixTree(rArray, limit);
                    }
                }, "build prefix tree2");
                oldIndices = (int[])rc.measure(new Executable(){

                    public Object execute() {
                        return LIMITOPJINDEXING.this.sortRelation(sArray);
                    }
                }, "sort S");
                partBegin = 1;
                sid = 1;
                pbIndex = 1;
                partBs = this.sOrder == 0 ? new int[sArray[1][0] + 1] : new int[sArray[sArray.length - 1][0] + 1];
                partBs[0] = 1;
                maxVal = this.sOrder == 0 ? sArray[1][0] : sArray[sArray.length - 1][0];
                i = 1;
                while (i < rArray.length) {
                    if (rArray[i][0] > maxVal) {
                        maxVal = rArray[i][0];
                    }
                    ++i;
                }
                if (this.sOrder != 0) break block8;
                kid = maxVal;
                ** GOTO lbl33
                {
                    ++sid;
                    do {
                        if (sid < sArray.length && sArray[sid][0] == kid) continue block1;
                        if (partBegin != sid) {
                            partBegin = sid;
                            partBs[pbIndex] = sid;
                            ++pbIndex;
                        }
                        --kid;
lbl33:
                        // 2 sources

                    } while (kid >= 0);
                }
                break block9;
            }
            if (this.sOrder != 1) break block9;
            kid = sArray[1][0];
            ** GOTO lbl47
            {
                ++sid;
                do {
                    if (sid < sArray.length && sArray[sid][0] == kid) continue block3;
                    if (partBegin != sid) {
                        partBegin = sid;
                        partBs[pbIndex] = sid;
                        ++pbIndex;
                    }
                    ++kid;
lbl47:
                    // 2 sources

                } while (kid <= maxVal);
            }
        }
        bounds = partBs;
        is = (LIMITOPJInvertedIndex)rc.measure(new Executable(){

            public Object execute() {
                LIMITOPJInvertedIndex ind = new LIMITOPJInvertedIndex();
                int i = 1;
                while (i < bounds.length) {
                    ind.fillIndex(sArray, bounds[i - 1], bounds[i]);
                    ++i;
                }
                return ind;
            }
        }, "build inv index");
        LIMITOPJINDEXING.LOGGER.info("{}", (Object)rc);
    }

    public void processNode(LIMITAPrefixTreeNode currentNode, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray, int[] oldSIndices) {
        TIntArrayList tuples = invertedIndex.get(currentNode.getName());
        if (tuples.size() == 0) {
            return;
        }
        this.verifySmart(currentNode, tuples, limit, rArray, sArray, oldSIndices, result);
        for (Node c : currentNode.getChildren()) {
            this.processNodeRecursion((LIMITAPrefixTreeNode)c, tuples, invertedIndex, result, limit, rArray, sArray, oldSIndices);
        }
    }

    public void processNodeRecursion(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray, int[] oldSIndices) {
        TIntArrayList tuples = TupleIDList.intersectHybrid(tupleIDCandidates, invertedIndex.get(currentNode.getName()), sArray);
        if (tuples.size() == 0) {
            return;
        }
        this.verifySmart(currentNode, tuples, limit, rArray, sArray, oldSIndices, result);
        for (Node c : currentNode.getChildren()) {
            this.processNodeRecursion((LIMITAPrefixTreeNode)c, tuples, invertedIndex, result, limit, rArray, sArray, oldSIndices);
        }
    }

    public void verifySmart(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, int safe, int[][] rArray, int[][] sArray, int[] oldSIndices, Result result) {
        TIntIterator it = tupleIDCandidates.iterator();
        while (it.hasNext()) {
            IntListIterator itr;
            int s = it.next();
            if (currentNode.containsTuples()) {
                itr = currentNode.getTupleIds().iterator();
                while (itr.hasNext()) {
                    int r = (Integer)itr.next();
                    result.add(r, oldSIndices[s]);
                    ++this.myresult;
                }
            }
            if (!currentNode.containsCutOffs()) continue;
            itr = currentNode.getCutOffTuples().iterator();
            int[] sSet = sArray[s];
            while (itr.hasNext()) {
                int r = (Integer)itr.next();
                int[] rSet = rArray[r];
                if (!this.qualify(rSet, sSet, safe)) continue;
                result.add(r, oldSIndices[s]);
                ++this.myresult;
            }
        }
    }

    public boolean qualify(int[] rSet, int[] sSet, int limit) {
        block7: {
            block6: {
                if (this.sOrder != 1) break block6;
                int sCnt = limit;
                int rCnt = limit;
                while (rCnt < rSet.length) {
                    int element = rSet[rCnt];
                    while (sCnt < sSet.length && sSet[sCnt] < element) {
                        ++sCnt;
                    }
                    if (sCnt >= sSet.length || sSet[sCnt] != element) {
                        return false;
                    }
                    ++sCnt;
                    ++rCnt;
                }
                break block7;
            }
            if (this.sOrder != 0) break block7;
            int sCnt = limit;
            int rCnt = limit;
            while (rCnt < rSet.length) {
                int element = rSet[rCnt];
                while (sCnt < sSet.length && sSet[sCnt] > element) {
                    ++sCnt;
                }
                if (sCnt >= sSet.length || sSet[sCnt] != element) {
                    return false;
                }
                ++sCnt;
                ++rCnt;
            }
        }
        return true;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }
}

