/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.limitcomplete;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.limitremade.structures.LIMITAPrefixTree;
import scj.algorithm.limitremade.structures.LIMITAPrefixTreeNode;
import scj.algorithm.limitremade.structures.LIMITOPJInvertedIndex;
import scj.algorithm.limitremade.structures.TupleIDList;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class LIMIT
extends ConfigurableRawDataAlgorithm
implements RawDataAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(LIMIT.class);
    SortOrder sortOrder;
    static final int SORT_ASC = 0;
    static final int SORT_DESC = 1;
    int sOrder;
    static int debug = 0;
    static int limit = 4;
    static boolean DEBUG = false;
    static boolean SHOWTREE = false;
    static long candidateCnt;
    int[][] rdArray;
    int[][] sdArray;

    public LIMIT(int limit, String so) {
        LIMIT.limit = limit;
        if (so.equals("ASC")) {
            this.sOrder = 0;
            this.sortOrder = new InverseFrequencyOrder();
        } else if (so.equals("DESC")) {
            this.sOrder = 1;
            this.sortOrder = new FrequencyOrder();
        }
        candidateCnt = 0L;
    }

    @Override
    public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        int[] dtSet;
        this.sortOrder.initialize(set1);
        for (DataTuple r : set1) {
            r.setSet(this.sortOrder.sort(r.getSet()));
        }
        this.sortOrder.initialize(set2);
        for (DataTuple r : set2) {
            r.setSet(this.sortOrder.sort(r.getSet()));
        }
        this.rdArray = new int[set1.size() + 1][];
        for (DataTuple dt : set1) {
            dtSet = dt.getSet();
            this.rdArray[dt.getId()] = dtSet;
        }
        this.sdArray = new int[set2.size() + 1][];
        for (DataTuple dt : set2) {
            dtSet = dt.getSet();
            this.sdArray[dt.getId()] = dtSet;
        }
        System.out.println("data array built");
    }

    @Override
    public void execute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        System.out.println("LIMIT with limit=" + limit);
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final int[][] rArray = this.rdArray;
        final int[][] sArray = this.sdArray;
        LIMITAPrefixTree tr = (LIMITAPrefixTree)rc.measure(new Executable(){

            public Object execute() {
                return new LIMITAPrefixTree(rArray, limit);
            }
        }, "build prefix tree2");
        System.out.println("prefixtree built");
        LIMITOPJInvertedIndex is = (LIMITOPJInvertedIndex)rc.measure(new Executable(){

            public Object execute() {
                return new LIMITOPJInvertedIndex(sArray);
            }
        }, "build inv index2");
        System.out.println("inverted index built");
        for (Node c : tr.getChildren()) {
            this.processNode((LIMITAPrefixTreeNode)c, is, result, limit, rArray, sArray);
        }
        LOGGER.info("{}", (Object)rc);
    }

    public void processNode(LIMITAPrefixTreeNode currentNode, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray) {
        TIntArrayList tuples = invertedIndex.get(currentNode.getName());
        if (tuples.size() == 0) {
            return;
        }
        this.verifySmart(currentNode, tuples, limit, rArray, sArray, result);
        for (Node c : currentNode.getChildren()) {
            this.processNodeRecursion((LIMITAPrefixTreeNode)c, tuples, invertedIndex, result, limit, rArray, sArray);
        }
    }

    public void processNodeRecursion(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, LIMITOPJInvertedIndex invertedIndex, Result result, int limit, int[][] rArray, int[][] sArray) {
        TIntArrayList tuples = TupleIDList.intersectHybrid(tupleIDCandidates, invertedIndex.get(currentNode.getName()), sArray);
        if (tuples.size() == 0) {
            return;
        }
        this.verifySmart(currentNode, tuples, limit, rArray, sArray, result);
        for (Node c : currentNode.getChildren()) {
            this.processNodeRecursion((LIMITAPrefixTreeNode)c, tuples, invertedIndex, result, limit, rArray, sArray);
        }
    }

    public void verifySmart(LIMITAPrefixTreeNode currentNode, TIntArrayList tupleIDCandidates, int safe, int[][] rArray, int[][] sArray, Result result) {
        TIntIterator it = tupleIDCandidates.iterator();
        while (it.hasNext()) {
            IntListIterator itr;
            int s = it.next();
            if (currentNode.containsTuples()) {
                itr = currentNode.getTupleIds().iterator();
                while (itr.hasNext()) {
                    int r = (Integer)itr.next();
                    ++candidateCnt;
                    result.add(r, s);
                }
            }
            if (!currentNode.containsCutOffs()) continue;
            itr = currentNode.getCutOffTuples().iterator();
            int[] sSet = sArray[s];
            while (itr.hasNext()) {
                int r = (Integer)itr.next();
                int[] rSet = rArray[r];
                if (!this.qualify(rSet, sSet, safe)) continue;
                result.add(r, s);
            }
        }
    }

    public boolean qualify(int[] rSet, int[] sSet, int limit) {
        block7: {
            block6: {
                ++candidateCnt;
                if (this.sOrder != 1) break block6;
                int sCnt = limit;
                int rCnt = limit;
                while (rCnt < rSet.length) {
                    int element = rSet[rCnt];
                    while (sCnt < sSet.length && sSet[sCnt] < element) {
                        ++sCnt;
                    }
                    if (sCnt >= sSet.length || sSet[sCnt] != element) {
                        return false;
                    }
                    ++sCnt;
                    ++rCnt;
                }
                break block7;
            }
            if (this.sOrder != 0) break block7;
            int sCnt = limit;
            int rCnt = limit;
            while (rCnt < rSet.length) {
                int element = rSet[rCnt];
                while (sCnt < sSet.length && sSet[sCnt] > element) {
                    ++sCnt;
                }
                if (sCnt >= sSet.length || sSet[sCnt] != element) {
                    return false;
                }
                ++sCnt;
                ++rCnt;
            }
        }
        return true;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }
}

