/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.tq;

import org.teatrove.trove.util.tq.TransactionQueue;
import org.teatrove.trove.util.tq.TransactionQueueAdapter;
import org.teatrove.trove.util.tq.TransactionQueueEvent;

public class TransactionQueueThreadTuner
extends TransactionQueueAdapter {
    private long mLastQueueTime;
    private long mLastServiceTime;
    private long mTotalQueueDelta;
    private long mTotalServiceDelta;
    private boolean mBaton;

    @Override
    public synchronized void transactionDequeued(TransactionQueueEvent e) {
        long queueTime = e.getStageDuration();
        this.mTotalQueueDelta += queueTime - this.mLastQueueTime;
        this.mLastQueueTime = queueTime;
        if (!this.mBaton) {
            this.mBaton = true;
            this.tune(e);
        }
    }

    @Override
    public synchronized void transactionServiced(TransactionQueueEvent e) {
        long serviceTime = e.getStageDuration();
        this.mTotalServiceDelta += serviceTime - this.mLastServiceTime;
        this.mLastServiceTime = serviceTime;
        if (this.mBaton) {
            this.mBaton = false;
            this.tune(e);
        }
    }

    private void tune(TransactionQueueEvent e) {
        TransactionQueue queue;
        int maxThreads;
        if (this.mTotalQueueDelta > this.mTotalServiceDelta) {
            TransactionQueue queue2 = e.getTransactionQueue();
            int maxThreads2 = queue2.getMaximumThreads();
            if (maxThreads2 <= queue2.getThreadCount() * 2) {
                queue2.setMaximumThreads(maxThreads2 + 1);
            }
        } else if (this.mTotalServiceDelta > this.mTotalQueueDelta && (maxThreads = (queue = e.getTransactionQueue()).getMaximumThreads()) > 1) {
            queue.setMaximumThreads(maxThreads - 1);
        }
    }
}

