/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.tq;

import java.util.Date;
import java.util.EventObject;
import org.teatrove.trove.util.tq.Transaction;
import org.teatrove.trove.util.tq.TransactionQueue;

public class TransactionQueueEvent
extends EventObject {
    private Transaction mTransaction;
    private Throwable mThrowable;
    private long mTimestampMillis;
    private long mStageDuration;
    private transient Date mTimestamp;

    public TransactionQueueEvent(TransactionQueue source, Transaction transaction) {
        super(source);
        this.mTransaction = transaction;
        this.mTimestampMillis = System.currentTimeMillis();
    }

    public TransactionQueueEvent(TransactionQueue source, Transaction transaction, Throwable throwable) {
        super(source);
        this.mTransaction = transaction;
        this.mThrowable = throwable;
        this.mTimestampMillis = System.currentTimeMillis();
    }

    public TransactionQueueEvent(TransactionQueueEvent event) {
        super(event.getSource());
        this.mTransaction = event.mTransaction;
        this.mThrowable = event.mThrowable;
        this.mTimestampMillis = System.currentTimeMillis();
        this.mStageDuration = this.mTimestampMillis - event.mTimestampMillis;
    }

    public TransactionQueueEvent(TransactionQueueEvent event, Throwable throwable) {
        super(event.getSource());
        this.mTransaction = event.mTransaction;
        this.mThrowable = throwable;
        this.mTimestampMillis = System.currentTimeMillis();
        this.mStageDuration = this.mTimestampMillis - event.mTimestampMillis;
    }

    public TransactionQueue getTransactionQueue() {
        return (TransactionQueue)this.getSource();
    }

    public Date getTimestamp() {
        if (this.mTimestamp == null) {
            this.mTimestamp = new Date(this.mTimestampMillis);
        }
        return this.mTimestamp;
    }

    public long getTimestampMillis() {
        return this.mTimestampMillis;
    }

    public long getStageDuration() {
        return this.mStageDuration;
    }

    public Transaction getTransaction() {
        return this.mTransaction;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }
}

