/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyMapFactory;
import org.teatrove.trove.util.PropertyMapFactoryProvider;
import org.teatrove.trove.util.SubstitutionFactory;
import org.teatrove.trove.util.resources.ResourceFactory;

public class DefaultResourceFactory
implements ResourceFactory {
    private static final DefaultResourceFactory INSTANCE = new DefaultResourceFactory();
    private PropertyMap substitutions;

    public DefaultResourceFactory() {
        this(SubstitutionFactory.getDefaults());
    }

    public DefaultResourceFactory(PropertyMap substitutions) {
        this.substitutions = substitutions;
    }

    public static DefaultResourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        File file = new File(path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return DefaultResourceFactory.class.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException fnfe) {
            return DefaultResourceFactory.class.getResourceAsStream(path);
        }
    }

    @Override
    public PropertyMap getResourceAsProperties(String path) throws IOException {
        return this.getResourceAsProperties(path, this.substitutions);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, InputStream input) throws IOException {
        return this.getResourceAsProperties(path, input, this.substitutions);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, PropertyMap substitutions) throws IOException {
        InputStream input = this.getResourceAsStream(path);
        if (input == null) {
            return null;
        }
        return this.getResourceAsProperties(path, input, substitutions);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, InputStream input, PropertyMap substitutions) throws IOException {
        if (input == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(input);
        PropertyMapFactory factory = PropertyMapFactoryProvider.createPropertyMapFactory(path, reader, substitutions);
        return factory.createProperties();
    }
}

