/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.properties;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;
import org.teatrove.trove.log.Syslog;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.properties.SubstitutionFactory;

public class FileSubstitutionFactory
implements SubstitutionFactory {
    private Properties m_subs = new Properties();

    @Override
    public void init(PropertyMap props) {
        String sFile = props.getString("file");
        if (sFile == null) {
            Syslog.error("No file specified for FileSubstitutionFactory");
            return;
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sFile));
            this.m_subs.load(bis);
        }
        catch (Exception e) {
            Syslog.error("Unable to load property substitutions from " + sFile);
            Syslog.error(e);
        }
    }

    @Override
    public String getSubstitution(String key) {
        return this.m_subs.getProperty(key);
    }
}

