/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.plugin;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyParser;
import org.teatrove.trove.util.XMLMapFactory;
import org.teatrove.trove.util.plugin.Plugin;
import org.teatrove.trove.util.plugin.PluginConfigSupport;
import org.teatrove.trove.util.plugin.PluginException;
import org.teatrove.trove.util.plugin.PluginFactoryConfig;
import org.teatrove.trove.util.plugin.PluginFactoryConfigSupport;
import org.teatrove.trove.util.plugin.PluginFactoryException;

public class PluginFactory {
    private static final String cClassKey = "class";
    private static final String cInitKey = "init";
    private static final String cPluginsKey = "plugins";
    private static final String cInjectedFileKey = "propertyInjector";
    private static final String cExternalPropKey = "externalProperty";
    private static final String cExternalNameKey = "externalPluginName";

    public static final Plugin createPlugin(String name, PluginFactoryConfig config) throws PluginFactoryException {
        Plugin result;
        PropertyMap injectedProps;
        String className = config.getProperties().getString(cClassKey);
        PropertyMap props = config.getProperties().subMap(cInitKey);
        if (config.getProperties().containsKey(cInjectedFileKey)) {
            try {
                if (props == null) {
                    props = new PropertyMap();
                }
                injectedProps = new PropertyMap();
                PropertyParser parser = new PropertyParser(props);
                parser.parse(new FileReader((String)config.getProperties().get(cInjectedFileKey)));
                props.putAll(injectedProps);
            }
            catch (IOException e) {
                new PluginFactoryException(e);
            }
            catch (Exception e) {
                new PluginFactoryException(e);
            }
        }
        if (config.getProperties().containsKey(cExternalPropKey)) {
            try {
                Element rootElement;
                if (props == null) {
                    props = new PropertyMap();
                }
                injectedProps = new PropertyMap();
                String externalPlugin = config.getProperties().getString(cExternalNameKey);
                Document pluginsDoc = null;
                pluginsDoc = XMLMapFactory.createDocument(new FileReader((String)config.getProperties().get(cExternalPropKey)));
                if (pluginsDoc != null && (rootElement = pluginsDoc.getRootElement()) != null) {
                    Element child = null;
                    if (externalPlugin != null) {
                        config.getLog().debug(name + " is loading the external plugin " + externalPlugin);
                        child = rootElement.getChild(externalPlugin);
                    } else {
                        child = rootElement.getChild(name);
                    }
                    if (child != null) {
                        injectedProps = XMLMapFactory.getPropertyMapFromElement(child);
                        if (className == null) {
                            className = child.getChildText(cClassKey);
                        }
                    }
                }
                if (injectedProps != null) {
                    if (externalPlugin != null) {
                        props.putAll(injectedProps.subMap(externalPlugin).subMap(cInitKey));
                    } else {
                        props.putAll(injectedProps.subMap(name).subMap(cInitKey));
                    }
                }
            }
            catch (Exception e) {
                throw new PluginFactoryException("Error loading external properties for " + name, e);
            }
        }
        try {
            Class<?> clazz = Class.forName(className);
            result = (Plugin)clazz.newInstance();
            PluginConfigSupport pluginConfig = new PluginConfigSupport(props, config.getLog(), config.getPluginContext(), name);
            result.init(pluginConfig);
        }
        catch (PluginException e) {
            throw new PluginFactoryException(e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginFactoryException(e);
        }
        catch (InstantiationException e) {
            throw new PluginFactoryException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginFactoryException(e);
        }
        return result;
    }

    public static final Plugin[] createPlugins(PluginFactoryConfig config) throws PluginFactoryException {
        PropertyMap properties = config.getProperties().subMap(cPluginsKey);
        if (properties.containsKey("properties.file")) {
            String defaultsFileName = (String)properties.remove("properties.file");
            PluginFactory.loadDefaults(defaultsFileName, properties, config.getLog());
        }
        Set<String> keySet = properties.subMapKeySet();
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>(keySet.size());
        Iterator<Object> iterator = keySet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            PropertyMap initProps = properties.subMap(name);
            PluginFactoryConfigSupport conf = new PluginFactoryConfigSupport(initProps, config.getLog(), config.getPluginContext());
            try {
                plugins.put(name, PluginFactory.createPlugin(name, conf));
            }
            catch (Exception e) {
                config.getLog().error("Error loading plugin: " + name);
                config.getLog().error(e);
            }
            ++i;
        }
        Map<String, Plugin> registeredPlugins = config.getPluginContext().getPlugins();
        keySet = registeredPlugins.keySet();
        for (String name : keySet) {
            if (plugins.containsKey(name)) continue;
            plugins.put(name, registeredPlugins.get(name));
        }
        Plugin[] result = new Plugin[plugins.size()];
        result = plugins.values().toArray(result);
        return result;
    }

    private static void loadDefaults(String filename, PropertyMap props, Log log) {
        log.info("loading Plugin defaults");
        try {
            PropertyMap defaults = new PropertyMap();
            FileReader fr = new FileReader(filename);
            PropertyParser pp = new PropertyParser(defaults);
            pp.parse(fr);
            log.info("loaded " + defaults.size() + " default keys");
            props.putDefaults(defaults);
        }
        catch (IOException ioe) {
            log.error(ioe);
        }
    }
}

