/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.plugin.Plugin;
import org.teatrove.trove.util.plugin.PluginEvent;
import org.teatrove.trove.util.plugin.PluginListener;
import org.teatrove.trove.util.resources.DefaultResourceFactory;
import org.teatrove.trove.util.resources.ResourceFactory;

public class PluginContext
implements ResourceFactory {
    private List<PluginListener> mPluginListeners;
    private Map<String, Plugin> mPluginMap;
    private ResourceFactory mResourceFactory;

    public PluginContext() {
        this(DefaultResourceFactory.getInstance());
    }

    public PluginContext(ResourceFactory resourceFactory) {
        this.mResourceFactory = resourceFactory;
        this.mPluginListeners = new ArrayList<PluginListener>();
        this.mPluginMap = new HashMap<String, Plugin>(7);
    }

    public ResourceFactory getResourceFactory() {
        return this.mResourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mResourceFactory = resourceFactory;
    }

    public void addPluginListener(PluginListener listener) {
        if (!this.mPluginListeners.contains(listener)) {
            this.mPluginListeners.add(listener);
        }
    }

    public void addPlugin(Plugin plugin) {
        if (!this.mPluginMap.containsKey(plugin.getName())) {
            this.mPluginMap.put(plugin.getName(), plugin);
            PluginEvent event = new PluginEvent(this, plugin);
            this.firePluginAddedEvent(event);
        }
    }

    public Plugin getPlugin(String name) {
        return this.mPluginMap.get(name);
    }

    public Map<String, Plugin> getPlugins() {
        return new HashMap<String, Plugin>(this.mPluginMap);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResourceAsStream(path);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path) throws IOException {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResourceAsProperties(path);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, InputStream input) throws IOException {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResourceAsProperties(path, input);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, PropertyMap substitutions) throws IOException {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResourceAsProperties(path, substitutions);
    }

    @Override
    public PropertyMap getResourceAsProperties(String path, InputStream input, PropertyMap substitutions) throws IOException {
        if (this.mResourceFactory == null) {
            return null;
        }
        return this.mResourceFactory.getResourceAsProperties(path, input, substitutions);
    }

    protected void firePluginAddedEvent(PluginEvent event) {
        PluginListener[] listeners = new PluginListener[this.mPluginListeners.size()];
        listeners = this.mPluginListeners.toArray(listeners);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].pluginAdded(event);
        }
    }
}

