/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.IOException;
import java.io.Reader;
import org.jdom.Document;
import org.jdom.Element;
import org.teatrove.trove.util.PropertyChangeListener;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyMapFactory;
import org.teatrove.trove.util.XMLMapFactory;

public class XMLPropertyMapFactory
implements PropertyMapFactory {
    private Reader reader;
    private boolean stripRoot;

    public XMLPropertyMapFactory(Reader reader) {
        this(reader, false);
    }

    public XMLPropertyMapFactory(Reader reader, boolean stripRoot) {
        this.reader = reader;
        this.stripRoot = stripRoot;
    }

    @Override
    public PropertyMap createProperties() throws IOException {
        return this.createProperties(null);
    }

    @Override
    public PropertyMap createProperties(PropertyChangeListener listener) throws IOException {
        try {
            Document document = XMLMapFactory.createDocument(this.reader);
            Element element = document.getRootElement();
            PropertyMap properties = XMLMapFactory.getPropertyMapFromElement(element);
            if (this.stripRoot && properties.size() > 0) {
                properties = properties.subMap(element.getName());
            }
            return properties;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

