/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WrappedCache
extends AbstractMap
implements Map {
    private final Map mCacheMap;
    private final Map mBackingMap;

    public WrappedCache(Map cacheMap, Map backingMap) {
        this.mCacheMap = cacheMap;
        this.mBackingMap = backingMap;
    }

    @Override
    public int size() {
        return this.mBackingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mBackingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mCacheMap.containsKey(key) || this.mBackingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mCacheMap.containsValue(value) || this.mBackingMap.containsValue(value);
    }

    public Object get(Object key) {
        Object value = this.mCacheMap.get(key);
        if (value != null || this.mCacheMap.containsKey(key)) {
            return value;
        }
        value = this.mBackingMap.get(key);
        if (value != null || this.mBackingMap.containsKey(key)) {
            this.mCacheMap.put(key, value);
        }
        return value;
    }

    public Object put(Object key, Object value) {
        this.mCacheMap.put(key, value);
        return this.mBackingMap.put(key, value);
    }

    public Object remove(Object key) {
        this.mCacheMap.remove(key);
        return this.mBackingMap.remove(key);
    }

    @Override
    public void clear() {
        this.mCacheMap.clear();
        this.mBackingMap.clear();
    }

    public Set keySet() {
        return this.mBackingMap.keySet();
    }

    public Collection values() {
        return this.mBackingMap.values();
    }

    public Set entrySet() {
        return this.mBackingMap.entrySet();
    }
}

