/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.teatrove.trove.util.FlyweightSet;

public class Utils {
    public static final Enumeration EMPTY_ENUMERATION = new EmptyEnum();
    public static final Map EMPTY_MAP = new EmptyMap();
    public static final Map<?, ?> VOID_MAP = new VoidMap();
    private static final Comparator NULL_LOW_ORDER = new NullLowOrder();
    private static final Comparator NULL_HIGH_ORDER = new NullHighOrder();
    private static final Comparator NULL_EQUAL_ORDER = new NullEqualOrder();
    private static FlyweightSet cFlyweightSet;

    public static final <K, V> Map<K, V> voidMap() {
        return new VoidMap();
    }

    public static Comparator nullLowOrder() {
        return NULL_LOW_ORDER;
    }

    public static Comparator nullLowOrder(Comparator c) {
        return new NullLowOrderC(c);
    }

    public static Comparator nullHighOrder() {
        return NULL_HIGH_ORDER;
    }

    public static Comparator nullHighOrder(Comparator c) {
        return new NullHighOrderC(c);
    }

    public static Comparator nullEqualOrder() {
        return NULL_EQUAL_ORDER;
    }

    public static Comparator nullEqualOrder(Comparator c) {
        return new NullEqualOrderC(c);
    }

    public static Comparator reverseOrder(Comparator c) {
        return new ReverseOrderC(c);
    }

    public static synchronized Object intern(Object obj) {
        FlyweightSet set = cFlyweightSet;
        if (set == null) {
            cFlyweightSet = set = new FlyweightSet();
        }
        return set.put(obj);
    }

    protected Utils() {
    }

    private static class ReverseOrderC
    implements Comparator,
    Serializable {
        private Comparator c;

        public ReverseOrderC(Comparator c) {
            this.c = c;
        }

        public int compare(Object obj1, Object obj2) {
            return this.c.compare(obj2, obj1);
        }
    }

    private static class NullEqualOrderC
    implements Comparator,
    Serializable {
        private Comparator c;

        public NullEqualOrderC(Comparator c) {
            this.c = c;
        }

        public int compare(Object obj1, Object obj2) {
            return obj1 != null && obj2 != null ? this.c.compare(obj1, obj2) : 0;
        }
    }

    private static class NullEqualOrder
    implements Comparator,
    Serializable {
        private NullEqualOrder() {
        }

        public int compare(Object obj1, Object obj2) {
            return obj1 != null && obj2 != null ? ((Comparable)obj1).compareTo(obj2) : 0;
        }

        private Object readResolve() throws ObjectStreamException {
            return Utils.nullEqualOrder();
        }
    }

    private static class NullHighOrderC
    implements Comparator,
    Serializable {
        private Comparator c;

        public NullHighOrderC(Comparator c) {
            this.c = c;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null) {
                return obj2 != null ? this.c.compare(obj1, obj2) : -1;
            }
            return obj2 != null ? 1 : 0;
        }
    }

    private static class NullHighOrder
    implements Comparator,
    Serializable {
        private NullHighOrder() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null) {
                return obj2 != null ? ((Comparable)obj1).compareTo(obj2) : -1;
            }
            return obj2 != null ? 1 : 0;
        }

        private Object readResolve() throws ObjectStreamException {
            return Utils.nullHighOrder();
        }
    }

    private static class NullLowOrderC
    implements Comparator,
    Serializable {
        private Comparator c;

        public NullLowOrderC(Comparator c) {
            this.c = c;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null) {
                return obj2 != null ? this.c.compare(obj1, obj2) : 1;
            }
            return obj2 != null ? -1 : 0;
        }
    }

    private static class NullLowOrder
    implements Comparator,
    Serializable {
        private NullLowOrder() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null) {
                return obj2 != null ? ((Comparable)obj1).compareTo(obj2) : 1;
            }
            return obj2 != null ? -1 : 0;
        }

        private Object readResolve() throws ObjectStreamException {
            return Utils.nullLowOrder();
        }
    }

    private static final class VoidMap<K, V>
    extends EmptyMap<K, V> {
        private VoidMap() {
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
        }
    }

    private static class EmptyMap<K, V>
    implements Map<K, V>,
    Serializable {
        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Cannot put into immutable empty map");
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException("Cannot put into immutable empty map");
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        private Object readResolve() throws ObjectStreamException {
            return EMPTY_MAP;
        }
    }

    private static class EmptyEnum
    implements Enumeration,
    Serializable {
        private EmptyEnum() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        private Object readResolve() throws ObjectStreamException {
            return EMPTY_ENUMERATION;
        }
    }
}

