/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.teatrove.trove.util.AbstractMapEntry;

public class UsageMap
extends AbstractMap
implements Serializable {
    private Map mRecentMap;
    private boolean mReverse;
    private Entry mMostRecent;
    private Entry mLeastRecent;
    private transient Set mEntrySet;

    public UsageMap() {
        this(new HashMap());
    }

    public UsageMap(Map backingMap) {
        this.mRecentMap = backingMap;
    }

    public void setReverseOrder(boolean reverse) {
        this.mReverse = reverse;
    }

    public Object firstKey() throws NoSuchElementException {
        Entry first;
        Entry entry = first = this.mReverse ? this.mLeastRecent : this.mMostRecent;
        if (first != null) {
            return first.mKey;
        }
        if (this.mRecentMap.size() == 0) {
            throw new NoSuchElementException();
        }
        return null;
    }

    public Object lastKey() throws NoSuchElementException {
        Entry last;
        Entry entry = last = this.mReverse ? this.mMostRecent : this.mLeastRecent;
        if (last != null) {
            return last.mKey;
        }
        if (this.mRecentMap.size() == 0) {
            throw new NoSuchElementException();
        }
        return null;
    }

    @Override
    public int size() {
        return this.mRecentMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mRecentMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mRecentMap.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        Entry e = (Entry)this.mRecentMap.get(key);
        return e == null ? null : e.mValue;
    }

    @Override
    public Object put(Object key, Object value) {
        Object old;
        Entry e = (Entry)this.mRecentMap.get(key);
        if (e == null) {
            old = null;
            e = new Entry(key, value);
            this.mRecentMap.put(key, e);
        } else {
            old = e.mValue;
            e.mValue = value;
            if (e == this.mMostRecent) {
                return old;
            }
            if (e.mPrev == null) {
                this.mMostRecent = e.mNext;
            } else {
                e.mPrev.mNext = e.mNext;
            }
            if (e.mNext == null) {
                this.mLeastRecent = e.mPrev;
            } else {
                e.mNext.mPrev = e.mPrev;
            }
            e.mPrev = null;
        }
        if (this.mMostRecent == null) {
            this.mMostRecent = e;
        } else {
            e.mNext = this.mMostRecent;
            this.mMostRecent.mPrev = e;
            this.mMostRecent = e;
        }
        if (this.mLeastRecent == null) {
            this.mLeastRecent = e;
        }
        return old;
    }

    @Override
    public Object remove(Object key) {
        Entry e = (Entry)this.mRecentMap.remove(key);
        if (e == null) {
            return null;
        }
        if (e.mPrev == null) {
            this.mMostRecent = e.mNext;
        } else {
            e.mPrev.mNext = e.mNext;
        }
        if (e.mNext == null) {
            this.mLeastRecent = e.mPrev;
        } else {
            e.mNext.mPrev = e.mPrev;
        }
        return e.mValue;
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.mRecentMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mRecentMap.clear();
        this.mMostRecent = null;
        this.mLeastRecent = null;
    }

    @Override
    public Set entrySet() {
        if (this.mEntrySet != null) {
            return this.mEntrySet;
        }
        this.mEntrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                if (UsageMap.this.mReverse) {
                    return new Iterator(){
                        private Entry mPrev;
                        private Entry mLast;
                        {
                            this.mPrev = UsageMap.this.mLeastRecent;
                            this.mLast = null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mPrev != null;
                        }

                        public Object next() {
                            this.mLast = this.mPrev;
                            if (this.mLast == null) {
                                throw new NoSuchElementException();
                            }
                            this.mPrev = this.mPrev.mPrev;
                            return this.mLast;
                        }

                        @Override
                        public void remove() {
                            if (this.mLast == null) {
                                throw new IllegalStateException();
                            }
                            UsageMap.this.remove(this.mLast.mKey);
                            this.mLast = null;
                        }
                    };
                }
                return new Iterator(){
                    private Entry mNext;
                    private Entry mLast;
                    {
                        this.mNext = UsageMap.this.mMostRecent;
                        this.mLast = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNext != null;
                    }

                    public Object next() {
                        this.mLast = this.mNext;
                        if (this.mLast == null) {
                            throw new NoSuchElementException();
                        }
                        this.mNext = this.mNext.mNext;
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        if (this.mLast == null) {
                            throw new IllegalStateException();
                        }
                        UsageMap.this.remove(this.mLast.mKey);
                        this.mLast = null;
                    }
                };
            }

            @Override
            public int size() {
                return UsageMap.this.mRecentMap.size();
            }

            @Override
            public boolean isEmpty() {
                return UsageMap.this.mRecentMap.isEmpty();
            }

            @Override
            public boolean contains(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Entry e = (Entry)UsageMap.this.mRecentMap.get(((Map.Entry)obj).getKey());
                return e != null && e.equals(obj);
            }

            @Override
            public boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                if (this.contains(obj)) {
                    UsageMap.this.remove(((Map.Entry)obj).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                UsageMap.this.clear();
            }
        };
        return this.mEntrySet;
    }

    private static class Entry
    extends AbstractMapEntry
    implements Serializable {
        public Entry mPrev;
        public Entry mNext;
        public Object mKey;
        public Object mValue;

        public Entry(Object key, Object value) {
            this.mKey = key;
            this.mValue = value;
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        @Override
        public Object setValue(Object value) {
            Object old = this.mValue;
            this.mValue = value;
            return old;
        }
    }
}

