/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyMapFactory;
import org.teatrove.trove.util.resources.DefaultResourceFactory;
import org.teatrove.trove.util.resources.ResourceFactory;

public class SubstitutionFactory {
    private static final Pattern PARSER_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9_-]+)(:([^}]+))?\\}");

    private SubstitutionFactory() {
    }

    public static PropertyMap getDefaults() {
        PropertyMap vars = new PropertyMap();
        vars.putAll(System.getenv());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            vars.put(entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        return vars;
    }

    public static PropertyMap getSubstitutions(PropertyMap properties) throws IOException {
        return SubstitutionFactory.getSubstitutions(properties, DefaultResourceFactory.getInstance());
    }

    public static PropertyMap getSubstitutions(PropertyMap properties, ResourceFactory resourceFactory) throws IOException {
        PropertyMap props;
        PropertyMap factoryMap;
        PropertyMap props2;
        String file;
        PropertyMap subs = new PropertyMap();
        if (properties == null || properties.getBoolean("env", true)) {
            subs.putAll(System.getenv());
        }
        if (properties == null || properties.getBoolean("system", true)) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                subs.put(entry.getKey().toString(), (Object)entry.getValue().toString());
            }
        }
        if (properties != null && (file = properties.getString("file")) != null && (props2 = resourceFactory.getResourceAsProperties(file)) != null) {
            subs.putAll(props2);
        }
        if (properties != null && resourceFactory != null && (factoryMap = properties.subMap("factory")) != null && factoryMap.size() > 0) {
            try {
                subs.putAll(SubstitutionFactory.loadProperties(factoryMap));
            }
            catch (Exception exception) {
                throw new IOException("unable to load substitution factory", exception);
            }
        }
        if (properties != null && (props = properties.subMap("properties")) != null) {
            subs.putAll(props);
        }
        return subs;
    }

    public static String substitute(String value) {
        return SubstitutionFactory.substitute(value, SubstitutionFactory.getDefaults());
    }

    public static String substitute(String value, PropertyMap vars) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int idx = 0;
        int current = 0;
        int marker = 0;
        StringBuilder sb = new StringBuilder(value.length() + 32);
        while (idx >= 0) {
            idx = value.indexOf("${", current);
            if (idx < 0) continue;
            sb.append(value.substring(current, idx));
            current = value.indexOf(125, idx) + 1;
            marker = value.indexOf(58, idx) + 1;
            if (marker >= current) {
                marker = -1;
            }
            String type = null;
            String dflt = null;
            if (marker > 0) {
                dflt = value.substring(marker, current - 1);
                type = value.substring(idx + 2, marker - 1);
            } else {
                type = value.substring(idx + 2, current - 1);
            }
            String match = null;
            if (vars.containsKey(type)) {
                match = (String)vars.get(type);
            } else if (dflt != null) {
                match = dflt;
            }
            if (match == null) {
                sb.append("${").append(type).append('}');
                continue;
            }
            sb.append(match);
        }
        if (current < value.length()) {
            sb.append(value.substring(current));
        }
        return sb.toString();
    }

    protected String _substitute(String value, Map<String, String> vars) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Matcher matcher = PARSER_PATTERN.matcher(value);
        int idx = 0;
        StringBuilder sb = new StringBuilder(value.length() + 32);
        while (matcher.find()) {
            sb.append(value.substring(idx, matcher.start()));
            String type = matcher.group(1);
            String match = vars.get(type);
            if (match == null) {
                sb.append(matcher.group(0));
            } else {
                sb.append(match);
            }
            idx = matcher.end();
        }
        if (idx < value.length()) {
            sb.append(value.substring(idx));
        }
        return sb.toString();
    }

    private static PropertyMap loadProperties(PropertyMap factoryProps) throws Exception {
        String className = null;
        PropertyMapFactory factory = null;
        if (factoryProps != null && factoryProps.size() > 0 && (className = factoryProps.getString("class")) != null) {
            Class<?> factoryClass = Class.forName(className);
            Constructor<?> ctor = factoryClass.getConstructor(Map.class);
            factory = (PropertyMapFactory)ctor.newInstance(factoryProps.subMap("init"));
        }
        return factory == null ? null : factory.createProperties();
    }
}

