/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import org.teatrove.trove.util.ReadWriteLock;

public final class SecureReadWriteLock
implements ReadWriteLock {
    private final long mTimeout;
    private int mReadLocks;
    private Thread mUpgradableLockHeld;
    private Thread mWriteLockHeld;
    private int mWriteLockAttempts;
    private final ThreadLocal mLockInfoRef = new LockInfoRef();

    public SecureReadWriteLock() {
        this.mTimeout = -1L;
    }

    public SecureReadWriteLock(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void acquireReadLock() throws InterruptedException {
        this.acquireReadLock(this.mTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireReadLock(long timeout) throws InterruptedException {
        LockInfo info = (LockInfo)this.mLockInfoRef.get();
        if (info.mType == 0) {
            SecureReadWriteLock secureReadWriteLock = this;
            synchronized (secureReadWriteLock) {
                block9: {
                    if (!this.readLockAvailable()) {
                        if (timeout < 0L) {
                            do {
                                this.wait();
                            } while (!this.readLockAvailable());
                        } else {
                            if (timeout <= 0L) {
                                return false;
                            }
                            long expire = System.currentTimeMillis() + timeout;
                            do {
                                this.wait(timeout);
                                if (this.readLockAvailable()) break block9;
                            } while ((timeout = expire - System.currentTimeMillis()) > 0L);
                            return false;
                        }
                    }
                }
                ++this.mReadLocks;
            }
            info.mType = 1;
        }
        ++info.mCount;
        return true;
    }

    @Override
    public void acquireUpgradableLock() throws InterruptedException, IllegalStateException {
        this.acquireUpgradableLock(this.mTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireUpgradableLock(long timeout) throws InterruptedException, IllegalStateException {
        LockInfo info = (LockInfo)this.mLockInfoRef.get();
        int type = info.mType;
        if (type == 1) {
            throw new IllegalStateException("Cannot acquire an upgradable lock while thread holds only a read lock.");
        }
        if (type == 0) {
            SecureReadWriteLock secureReadWriteLock = this;
            synchronized (secureReadWriteLock) {
                block10: {
                    if (!this.upgradableLockAvailable()) {
                        if (timeout < 0L) {
                            do {
                                this.wait();
                            } while (!this.upgradableLockAvailable());
                        } else {
                            if (timeout <= 0L) {
                                return false;
                            }
                            long expire = System.currentTimeMillis() + timeout;
                            do {
                                this.wait(timeout);
                                if (this.upgradableLockAvailable()) break block10;
                            } while ((timeout = expire - System.currentTimeMillis()) > 0L);
                            return false;
                        }
                    }
                }
                this.mUpgradableLockHeld = Thread.currentThread();
            }
            info.mType = 2;
        }
        ++info.mCount;
        return true;
    }

    @Override
    public void acquireWriteLock() throws InterruptedException, IllegalStateException {
        this.acquireWriteLock(this.mTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireWriteLock(long timeout) throws InterruptedException, IllegalStateException {
        LockInfo info = (LockInfo)this.mLockInfoRef.get();
        int type = info.mType;
        if (type == 1) {
            throw new IllegalStateException("Cannot acquire a write lock while thread holds only a read lock. Use an upgradable lock instead of a read lock.");
        }
        if (type != 3) {
            SecureReadWriteLock secureReadWriteLock = this;
            synchronized (secureReadWriteLock) {
                if (type == 2) {
                    info.mUpgradeCount = info.mCount;
                }
                if (!this.writeLockAvailable(type)) {
                    if (timeout < 0L) {
                        ++this.mWriteLockAttempts;
                        try {
                            do {
                                this.wait();
                            } while (!this.writeLockAvailable(type));
                        }
                        catch (InterruptedException e) {
                            if (type == 2) {
                                info.mUpgradeCount = 0;
                            }
                            throw e;
                        }
                        finally {
                            --this.mWriteLockAttempts;
                        }
                    }
                    if (timeout <= 0L) {
                        return false;
                    }
                    ++this.mWriteLockAttempts;
                    long expire = System.currentTimeMillis() + timeout;
                    try {
                        do {
                            this.wait(timeout);
                        } while (!this.writeLockAvailable(type));
                        timeout = expire - System.currentTimeMillis();
                        if (timeout <= 0L) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (InterruptedException e) {
                        if (type == 2) {
                            info.mUpgradeCount = 0;
                        }
                        throw e;
                    }
                    finally {
                        --this.mWriteLockAttempts;
                    }
                }
                this.mWriteLockHeld = Thread.currentThread();
            }
            info.mType = 3;
        }
        ++info.mCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseLock() {
        LockInfo info = (LockInfo)this.mLockInfoRef.get();
        int type = info.mType;
        int count = info.mCount;
        if (count > 0) {
            --count;
        } else {
            type = 0;
            info.mType = 0;
            count = 0;
        }
        info.mCount = count;
        if (info.mCount == 0) {
            switch (type) {
                default: {
                    return false;
                }
                case 1: {
                    SecureReadWriteLock secureReadWriteLock = this;
                    synchronized (secureReadWriteLock) {
                        --this.mReadLocks;
                        this.notifyAll();
                        break;
                    }
                }
                case 2: {
                    SecureReadWriteLock secureReadWriteLock = this;
                    synchronized (secureReadWriteLock) {
                        this.mUpgradableLockHeld = null;
                        this.notifyAll();
                        break;
                    }
                }
                case 3: {
                    SecureReadWriteLock secureReadWriteLock = this;
                    synchronized (secureReadWriteLock) {
                        this.mWriteLockHeld = null;
                        this.notifyAll();
                        break;
                    }
                }
            }
            info.mType = 0;
        } else if (type == 3 && info.mUpgradeCount == count) {
            info.mType = 2;
            info.mUpgradeCount = 0;
            SecureReadWriteLock secureReadWriteLock = this;
            synchronized (secureReadWriteLock) {
                this.mWriteLockHeld = null;
                this.notifyAll();
            }
        }
        return true;
    }

    @Override
    public long getDefaultTimeout() {
        return this.mTimeout;
    }

    public int getLockType() {
        return ((LockInfo)this.mLockInfoRef.get()).mType;
    }

    public int getLockAcquisitions() {
        return ((LockInfo)this.mLockInfoRef.get()).mCount;
    }

    public synchronized int getReadLocksHeld() {
        return this.mReadLocks;
    }

    public synchronized Thread getUpgradableLockHeld() {
        return this.mUpgradableLockHeld;
    }

    public synchronized Thread getWriteLockHeld() {
        return this.mWriteLockHeld;
    }

    public synchronized String toString() {
        return super.toString() + '[' + this.mReadLocks + ',' + this.mUpgradableLockHeld + ',' + this.mWriteLockHeld + ']';
    }

    private boolean readLockAvailable() {
        return this.mWriteLockHeld == null && this.mWriteLockAttempts == 0;
    }

    private boolean upgradableLockAvailable() {
        return this.readLockAvailable() && this.mUpgradableLockHeld == null;
    }

    private boolean writeLockAvailable(int type) {
        if (this.mReadLocks == 0 && this.mWriteLockHeld == null) {
            return type == 2 ? true : this.mUpgradableLockHeld == null;
        }
        return false;
    }

    private static final class LockInfoRef
    extends ThreadLocal {
        private LockInfoRef() {
        }

        protected Object initialValue() {
            return new LockInfo();
        }
    }

    private static final class LockInfo {
        int mType = 0;
        int mCount;
        int mUpgradeCount;

        private LockInfo() {
        }
    }
}

