/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.teatrove.trove.io.SourceInfo;
import org.teatrove.trove.io.SourceReader;
import org.teatrove.trove.util.PropertyChangeEvent;
import org.teatrove.trove.util.PropertyChangeListener;

public class PropertyParser {
    private Map mMap;
    private Vector mPropertyListeners = new Vector(64);
    private Vector mErrorListeners = new Vector(1);
    private int mErrorCount = 0;
    private Scanner mScanner;

    public PropertyParser(Map map) {
        this.mMap = map;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyListeners.addElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPropertyChange(PropertyChangeEvent e) {
        Vector vector = this.mPropertyListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mPropertyListeners.size(); ++i) {
                ((PropertyChangeListener)this.mPropertyListeners.elementAt(i)).propertyChanged(e);
            }
        }
    }

    private void propertyChange(String key, String value, SourceInfo info) {
        this.dispatchPropertyChange(new PropertyChangeEvent(this, key, value, info));
    }

    public void addErrorListener(ErrorListener listener) {
        this.mErrorListeners.addElement(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.mErrorListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchParseError(ErrorEvent e) {
        ++this.mErrorCount;
        Vector vector = this.mErrorListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mErrorListeners.size(); ++i) {
                ((ErrorListener)this.mErrorListeners.elementAt(i)).parseError(e);
            }
        }
    }

    private void error(String str, SourceInfo info) {
        this.dispatchParseError(new ErrorEvent(this, str, info));
    }

    private void error(String str, Token token) {
        this.error(str, token.getSourceInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader) throws IOException {
        this.mScanner = new Scanner(reader);
        this.mScanner.addErrorListener(new ErrorListener(){

            @Override
            public void parseError(ErrorEvent e) {
                PropertyParser.this.dispatchParseError(e);
            }
        });
        try {
            this.parseProperties();
        }
        finally {
            this.mScanner.close();
        }
    }

    private void parseProperties() throws IOException {
        Token token;
        block4: while ((token = this.peek()).getId() != 1) {
            switch (token.getId()) {
                case 2: 
                case 3: 
                case 5: {
                    this.parsePropertyList(null);
                    continue block4;
                }
                case 6: {
                    token = this.read();
                    this.error("No matching left brace", token);
                    continue block4;
                }
            }
            token = this.read();
            this.error("Unexpected token: " + token.getValue(), token);
        }
    }

    private void parsePropertyList(String keyPrefix) throws IOException {
        Token token;
        block5: while ((token = this.peek()).getId() != 1) {
            switch (token.getId()) {
                case 3: {
                    token = this.read();
                    this.parseProperty(keyPrefix, token);
                    continue block5;
                }
                case 2: {
                    this.read();
                    continue block5;
                }
                case 5: {
                    this.read();
                    this.error("Nested properties must have a base name", token);
                    this.parseBlock(keyPrefix);
                    continue block5;
                }
            }
            break;
        }
    }

    private void parseProperty(String keyPrefix, Token token) throws IOException {
        String key = token.getValue();
        if (keyPrefix != null) {
            key = keyPrefix + key;
        }
        String value = null;
        if (this.peek().getId() == 4) {
            token = this.read();
            value = token.getValue();
        }
        if (this.peek().getId() == 5) {
            this.read();
            this.parseBlock(key + '.');
        } else if (value == null) {
            value = "";
        }
        if (value != null) {
            this.putProperty(key, value, token);
            this.propertyChange(key, value, token.getSourceInfo());
        }
    }

    private void parseBlock(String keyPrefix) throws IOException {
        this.parsePropertyList(keyPrefix);
        Token token = this.peek();
        if (token.getId() == 6) {
            this.read();
        } else {
            this.error("Right brace expected", token);
        }
    }

    private void putProperty(String key, String value, Token token) {
        if (this.mMap.containsKey(key)) {
            this.error("Property \"" + key + "\" already defined", token);
        }
        this.mMap.put(key, value);
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    private Token read() throws IOException {
        return this.mScanner.readToken();
    }

    private Token peek() throws IOException {
        return this.mScanner.peekToken();
    }

    private static class Scanner {
        private SourceReader mSource;
        private Stack mLookahead = new Stack();
        private boolean mScanKey = true;
        private Token mEOFToken;
        private Vector mListeners = new Vector(1);
        private int mErrorCount = 0;

        public Scanner(Reader in) {
            this.mSource = new SourceReader(in, null, null);
        }

        public void addErrorListener(ErrorListener listener) {
            this.mListeners.addElement(listener);
        }

        public void removeErrorListener(ErrorListener listener) {
            this.mListeners.removeElement(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchParseError(ErrorEvent e) {
            ++this.mErrorCount;
            Vector vector = this.mListeners;
            synchronized (vector) {
                for (int i = 0; i < this.mListeners.size(); ++i) {
                    ((ErrorListener)this.mListeners.elementAt(i)).parseError(e);
                }
            }
        }

        private void error(String str, SourceInfo info) {
            this.dispatchParseError(new ErrorEvent(this, str, info));
        }

        private void error(String str) {
            this.error(str, new SourceInfo(this.mSource.getLineNumber(), this.mSource.getStartPosition(), this.mSource.getEndPosition()));
        }

        public synchronized Token readToken() throws IOException {
            if (this.mLookahead.empty()) {
                return this.scanToken();
            }
            return (Token)this.mLookahead.pop();
        }

        public synchronized Token peekToken() throws IOException {
            if (this.mLookahead.empty()) {
                return this.mLookahead.push(this.scanToken());
            }
            return (Token)this.mLookahead.peek();
        }

        public synchronized void unreadToken(Token token) throws IOException {
            this.mLookahead.push(token);
        }

        public void close() throws IOException {
            this.mSource.close();
        }

        public int getErrorCount() {
            return this.mErrorCount;
        }

        private Token scanToken() throws IOException {
            int c;
            if (this.mSource.isClosed()) {
                if (this.mEOFToken == null) {
                    this.mEOFToken = this.makeToken(1, null);
                }
                return this.mEOFToken;
            }
            block9: while ((c = this.mSource.read()) != -1) {
                switch (c) {
                    case -3: 
                    case -2: {
                        continue block9;
                    }
                    case 33: 
                    case 35: {
                        this.mScanKey = true;
                        return this.scanComment();
                    }
                    case 123: {
                        this.mScanKey = true;
                        return this.makeToken(5, "{");
                    }
                    case 125: {
                        this.mScanKey = true;
                        return this.makeToken(6, "}");
                    }
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        this.mSource.unread();
                        return this.scanKeyOrValue();
                    }
                    case 10: {
                        this.mScanKey = true;
                    }
                    case 0: 
                    case 9: 
                    case 32: {
                        continue block9;
                    }
                }
                if (Character.isWhitespace((char)c)) continue;
                this.mSource.unread();
                return this.scanKeyOrValue();
            }
            if (this.mEOFToken == null) {
                this.mEOFToken = this.makeToken(1, null);
            }
            return this.mEOFToken;
        }

        private Token scanKeyOrValue() throws IOException {
            int tokenId;
            int c;
            StringBuffer buf = new StringBuffer(40);
            boolean trim = true;
            int startLine = this.mSource.getLineNumber();
            int startPos = this.mSource.getStartPosition();
            int endPos = this.mSource.getEndPosition();
            boolean skipWhitespace = true;
            boolean skipSeparator = true;
            block9: while ((c = this.mSource.read()) != -1) {
                switch (c) {
                    case 10: {
                        this.mSource.unread();
                        break block9;
                    }
                    case 92: {
                        int next = this.mSource.read();
                        if (next == -1 || next == 10) {
                            skipWhitespace = true;
                            continue block9;
                        }
                        c = this.processEscape(c, next);
                        skipWhitespace = false;
                        break;
                    }
                    case 123: 
                    case 125: {
                        this.mSource.unread();
                        break block9;
                    }
                    case 58: 
                    case 61: {
                        if (this.mScanKey) {
                            this.mSource.unread();
                            break block9;
                        }
                        if (skipSeparator) {
                            skipSeparator = false;
                            continue block9;
                        }
                        skipWhitespace = false;
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (buf.length() == 0) {
                            this.scanStringLiteral(c, buf);
                            endPos = this.mSource.getEndPosition();
                            trim = false;
                            break block9;
                        }
                    }
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        skipWhitespace = false;
                        break;
                    }
                    case 0: 
                    case 9: 
                    case 32: {
                        if (skipWhitespace) continue block9;
                        if (!this.mScanKey) break;
                        break block9;
                    }
                    default: {
                        if (Character.isWhitespace((char)c)) {
                            if (skipWhitespace) continue block9;
                            if (!this.mScanKey) break;
                            break block9;
                        }
                        skipWhitespace = false;
                    }
                }
                buf.append((char)c);
                endPos = this.mSource.getEndPosition();
                skipSeparator = false;
            }
            if (this.mScanKey) {
                tokenId = 3;
                this.mScanKey = false;
            } else {
                tokenId = 4;
                this.mScanKey = true;
            }
            String value = buf.toString();
            if (trim) {
                value = value.trim();
            }
            return new Token(startLine, startPos, endPos, tokenId, value);
        }

        private Token scanComment() throws IOException {
            int c;
            StringBuffer buf = new StringBuffer(40);
            int startLine = this.mSource.getLineNumber();
            int startPos = this.mSource.getStartPosition();
            int endPos = this.mSource.getEndPosition();
            while ((c = this.mSource.peek()) != -1 && c != 10) {
                this.mSource.read();
                buf.append((char)c);
                endPos = this.mSource.getEndPosition();
            }
            return new Token(startLine, startPos, endPos, 2, buf.toString());
        }

        private void scanStringLiteral(int quote, StringBuffer buf) throws IOException {
            int c;
            while ((c = this.mSource.read()) != -1) {
                if (c == quote) {
                    return;
                }
                if (c == 92) {
                    int next = this.mSource.read();
                    if (next == -1 || next == 10) continue;
                    c = this.processEscape(c, next);
                }
                buf.append((char)c);
            }
        }

        private int processEscape(int c, int next) {
            switch (next) {
                case 48: {
                    return 0;
                }
                case 116: {
                    return 9;
                }
                case 110: {
                    return 10;
                }
                case 102: {
                    return 12;
                }
                case 114: {
                    return 13;
                }
                case 34: 
                case 39: 
                case 58: 
                case 61: 
                case 92: 
                case 123: 
                case 125: {
                    return next;
                }
            }
            this.error("Invalid escape code: \\" + (char)next);
            return next;
        }

        private Token makeToken(int Id, String value) {
            return new Token(this.mSource.getLineNumber(), this.mSource.getStartPosition(), this.mSource.getEndPosition(), Id, value);
        }
    }

    private static class Token
    implements Serializable {
        public static final int UNKNOWN = 0;
        public static final int EOF = 1;
        public static final int COMMENT = 2;
        public static final int KEY = 3;
        public static final int VALUE = 4;
        public static final int LBRACE = 5;
        public static final int RBRACE = 6;
        private static final int LAST_ID = 6;
        private int mTokenId;
        private String mValue;
        private SourceInfo mInfo;

        Token(int sourceLine, int sourceStartPos, int sourceEndPos, int tokenId, String value) {
            this.mTokenId = tokenId;
            this.mValue = value;
            if (tokenId > 6) {
                throw new IllegalArgumentException("Token Id out of range: " + tokenId);
            }
            this.mInfo = new SourceInfo(sourceLine, sourceStartPos, sourceEndPos);
            if (sourceStartPos > sourceEndPos) {
                throw new IllegalArgumentException("Token start position greater than end position at line: " + sourceLine);
            }
        }

        public Token(SourceInfo info, int tokenId, String value) {
            this.mTokenId = tokenId;
            if (tokenId > 6) {
                throw new IllegalArgumentException("Token Id out of range: " + tokenId);
            }
            this.mInfo = info;
        }

        public final int getId() {
            return this.mTokenId;
        }

        public String getCode() {
            return Code.TOKEN_CODES[this.mTokenId];
        }

        public final SourceInfo getSourceInfo() {
            return this.mInfo;
        }

        public String getValue() {
            return this.mValue;
        }

        public String toString() {
            String str;
            StringBuffer buf = new StringBuffer(10);
            String image = this.getCode();
            if (image != null) {
                buf.append(image);
            }
            if ((str = this.getValue()) != null) {
                if (image != null) {
                    buf.append(' ');
                }
                buf.append('\"');
                buf.append(str);
                buf.append('\"');
            }
            return buf.toString();
        }

        private static class Code {
            public static final String[] TOKEN_CODES = new String[]{"UNKNOWN", "EOF", "COMMENT", "KEY", "VALUE", "LBRACE", "RBRACE"};

            private Code() {
            }
        }
    }

    public static class ErrorEvent
    extends EventObject {
        private String mErrorMsg;
        private SourceInfo mInfo;

        ErrorEvent(Object source, String errorMsg, SourceInfo info) {
            super(source);
            this.mErrorMsg = errorMsg;
            this.mInfo = info;
        }

        public String getErrorMessage() {
            return this.mErrorMsg;
        }

        public String getDetailedErrorMessage() {
            String prepend = this.getSourceInfoMessage();
            if (prepend == null || prepend.length() == 0) {
                return this.mErrorMsg;
            }
            return prepend + ": " + this.mErrorMsg;
        }

        public String getSourceInfoMessage() {
            if (this.mInfo == null) {
                return "";
            }
            return String.valueOf(this.mInfo.getLine());
        }

        public SourceInfo getSourceInfo() {
            return this.mInfo;
        }
    }

    public static interface ErrorListener
    extends EventListener {
        public void parseError(ErrorEvent var1);
    }
}

