/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.teatrove.trove.util.AbstractMapEntry;
import org.teatrove.trove.util.UsageMap;
import org.teatrove.trove.util.Utils;

public class PropertyMap
extends AbstractMap {
    public static final Class ELEMENT_TYPE = String.class;
    private Map mMappings;
    private String mSeparator;
    private String mPrefix;
    private transient Set mSubMapKeySet;
    private transient Set mSubKeySet;
    private transient Set mEntrySet;

    private static String internStr(String str) {
        return (String)Utils.intern(str);
    }

    public PropertyMap() {
        this(null, ".");
    }

    public PropertyMap(Map map) {
        this(map, ".");
    }

    public PropertyMap(String separator) {
        this(null, separator);
    }

    public PropertyMap(Map map, String separator) {
        UsageMap usageMap = new UsageMap();
        usageMap.setReverseOrder(true);
        this.mMappings = usageMap;
        this.mSeparator = separator;
        if (map != null) {
            this.putAll(map);
        }
    }

    private PropertyMap(String prefix, PropertyMap source) {
        this.mMappings = source;
        this.mSeparator = source.getSeparator();
        this.mPrefix = prefix;
    }

    public String getSeparator() {
        return this.mSeparator;
    }

    public PropertyMap subMap(String key) {
        if (key == null) {
            return this;
        }
        return new PropertyMap(key, this);
    }

    public Set subMapKeySet() {
        if (this.mSubMapKeySet == null) {
            this.mSubMapKeySet = new SubMapKeySet();
        }
        return this.mSubMapKeySet;
    }

    public Set subKeySet() {
        if (this.mSubKeySet == null) {
            this.mSubKeySet = new SubKeySet();
        }
        return this.mSubKeySet;
    }

    @Override
    public int size() {
        if (this.mPrefix == null) {
            return this.mMappings.size();
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.mPrefix == null) {
            return this.mMappings.isEmpty();
        }
        return super.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.containsKey(null);
        }
        return this.containsKey(key.toString());
    }

    public boolean containsKey(String key) {
        if (this.mPrefix == null) {
            return this.mMappings.containsKey(PropertyMap.internStr(key));
        }
        return this.mMappings.containsKey(this.mPrefix + this.mSeparator + key);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return this.get(null);
        }
        return this.get(key.toString());
    }

    public Object get(String key) {
        if (this.mPrefix == null) {
            return this.mMappings.get(PropertyMap.internStr(key));
        }
        return this.mMappings.get(this.mPrefix + this.mSeparator + key);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String getString(String key, String def) {
        Object value = this.get(key);
        if (value == null) {
            return def;
        }
        return value.toString();
    }

    public int getInt(String key) throws NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public int getInt(String key, int def) {
        String value = this.getString(key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer def) {
        String value = this.getString(key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Number getNumber(String key) throws NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.valueOf(value);
            }
        }
    }

    public Number getNumber(String key, Number def) {
        String value = this.getString(key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e2) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException e3) {
                    return def;
                }
            }
        }
    }

    public boolean getBoolean(String key) {
        return "true".equalsIgnoreCase(this.getString(key));
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.getString(key);
        if (value == null) {
            return def;
        }
        return "true".equalsIgnoreCase(value);
    }

    @Override
    public Set entrySet() {
        if (this.mPrefix == null) {
            return this.mMappings.entrySet();
        }
        if (this.mEntrySet == null) {
            this.mEntrySet = new EntrySet();
        }
        return this.mEntrySet;
    }

    @Override
    public Set keySet() {
        if (this.mPrefix == null) {
            return this.mMappings.keySet();
        }
        return super.keySet();
    }

    @Override
    public Collection values() {
        if (this.mPrefix == null) {
            return this.mMappings.values();
        }
        return super.values();
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            return this.put((String)null, value);
        }
        return this.put(key.toString(), value);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.mPrefix == null) {
            return this.mMappings.put(PropertyMap.internStr(key), value);
        }
        return this.mMappings.put(this.mPrefix + this.mSeparator + key, value);
    }

    public void putDefaults(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (this.containsKey(key)) continue;
            this.put(key, entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return this.remove(null);
        }
        return this.remove(key.toString());
    }

    public Object remove(String key) {
        if (this.mPrefix == null) {
            return this.mMappings.remove(PropertyMap.internStr(key));
        }
        return this.mMappings.remove(this.mPrefix + this.mSeparator + key);
    }

    @Override
    public void clear() {
        if (this.mPrefix == null) {
            this.mMappings.clear();
        } else {
            super.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                Object key = ((Map.Entry)obj).getKey();
                Object value = ((Map.Entry)obj).getValue();
                if (PropertyMap.this.containsKey(key)) {
                    Object v = PropertyMap.this.get(key);
                    if (v == null) {
                        if (value == null) {
                            PropertyMap.this.remove(key);
                            return true;
                        }
                    } else if (v.equals(value)) {
                        PropertyMap.this.remove(key);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                final Iterator mIterator;
                Map.Entry mNext;
                {
                    this.mIterator = PropertyMap.this.mMappings.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.mNext != null) {
                        return true;
                    }
                    String prefix = PropertyMap.this.mPrefix;
                    String sep = PropertyMap.this.mSeparator;
                    while (this.mIterator.hasNext()) {
                        String subKey;
                        final Map.Entry entry = (Map.Entry)this.mIterator.next();
                        String key = (String)entry.getKey();
                        if (key == null || !key.startsWith(prefix)) continue;
                        if (key.length() == prefix.length()) {
                            subKey = null;
                        } else {
                            if (!key.startsWith(sep, prefix.length())) continue;
                            subKey = key.substring(prefix.length() + sep.length());
                        }
                        this.mNext = new AbstractMapEntry(){

                            public Object getKey() {
                                return subKey;
                            }

                            public Object getValue() {
                                return entry.getValue();
                            }

                            @Override
                            public Object setValue(Object value) {
                                return PropertyMap.this.put(subKey, value);
                            }
                        };
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry next = this.mNext;
                    this.mNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    this.mIterator.remove();
                }
            };
        }
    }

    private class SubMapKeySet
    extends AbstractSet {
        private SubMapKeySet() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                final Iterator mIterator;
                Set mSeen;
                String mNext;
                {
                    this.mIterator = PropertyMap.this.keySet().iterator();
                    this.mSeen = new HashSet();
                }

                @Override
                public boolean hasNext() {
                    if (this.mNext != null) {
                        return true;
                    }
                    String sep = PropertyMap.this.mSeparator;
                    while (this.mIterator.hasNext()) {
                        String subKey;
                        int index;
                        String key = (String)this.mIterator.next();
                        if (key == null || (index = key.indexOf(sep)) < 0 || this.mSeen.contains(subKey = key.substring(0, index))) continue;
                        this.mSeen.add(subKey);
                        this.mNext = subKey;
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String next = this.mNext;
                    this.mNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class SubKeySet
    extends SubMapKeySet {
        private SubKeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                final Iterator mIterator;
                Set mSeen;
                String mNext;
                {
                    this.mIterator = PropertyMap.this.keySet().iterator();
                    this.mSeen = new HashSet();
                }

                @Override
                public boolean hasNext() {
                    if (this.mNext != null) {
                        return true;
                    }
                    String sep = PropertyMap.this.mSeparator;
                    while (this.mIterator.hasNext()) {
                        String key = (String)this.mIterator.next();
                        if (key == null) continue;
                        int index = key.indexOf(sep);
                        String subKey = key;
                        if (index >= 0) {
                            subKey = key.substring(0, index);
                        }
                        if (subKey == null || this.mSeen.contains(subKey)) continue;
                        this.mSeen.add(subKey);
                        this.mNext = subKey;
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String next = this.mNext;
                    this.mNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

