/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.Serializable;
import java.util.Arrays;

public class MultiKey
implements Serializable {
    private final Object mComponent;
    private final int mHash;

    static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        Class<?> clazz = obj.getClass();
        int hash = clazz.hashCode();
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + array[i];
            }
        } else if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + MultiKey.hashCode(array[i]);
            }
        } else if (obj instanceof float[]) {
            float[] array = (float[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + Float.floatToIntBits(array[i]);
            }
        } else if (obj instanceof long[]) {
            long[] array = (long[])obj;
            int i = array.length;
            while (--i >= 0) {
                long value = array[i];
                hash = hash * 31 + (int)(value ^ value >>> 32);
            }
        } else if (obj instanceof double[]) {
            double[] array = (double[])obj;
            int i = array.length;
            while (--i >= 0) {
                long value = Double.doubleToLongBits(array[i]);
                hash = hash * 31 + (int)(value ^ value >>> 32);
            }
        } else if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + array[i];
            }
        } else if (obj instanceof char[]) {
            char[] array = (char[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + array[i];
            }
        } else if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + (array[i] ? 1 : 0);
            }
        } else if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = array.length;
            while (--i >= 0) {
                hash = hash * 31 + array[i];
            }
        } else {
            hash = obj.hashCode();
        }
        return hash;
    }

    static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        Class<?> clazz1 = obj1.getClass();
        if (clazz1 != obj2.getClass()) {
            return false;
        }
        if (obj1 instanceof int[]) {
            return Arrays.equals((int[])obj1, (int[])obj2);
        }
        if (obj1 instanceof Object[]) {
            Object[] array1 = (Object[])obj1;
            int i = array1.length;
            Object[] array2 = (Object[])obj2;
            if (i != array2.length) {
                return false;
            }
            while (--i >= 0) {
                if (MultiKey.equals(array1[i], array2[i])) continue;
                return false;
            }
            return true;
        }
        if (obj1 instanceof float[]) {
            return Arrays.equals((float[])obj1, (float[])obj2);
        }
        if (obj1 instanceof long[]) {
            return Arrays.equals((long[])obj1, (long[])obj2);
        }
        if (obj1 instanceof double[]) {
            return Arrays.equals((double[])obj1, (double[])obj2);
        }
        if (obj1 instanceof byte[]) {
            return Arrays.equals((byte[])obj1, (byte[])obj2);
        }
        if (obj1 instanceof char[]) {
            return Arrays.equals((char[])obj1, (char[])obj2);
        }
        if (obj1 instanceof boolean[]) {
            return Arrays.equals((boolean[])obj1, (boolean[])obj2);
        }
        if (obj1 instanceof short[]) {
            return Arrays.equals((short[])obj1, (short[])obj2);
        }
        return obj1.equals(obj2);
    }

    public MultiKey(Object component) {
        this.mComponent = component;
        this.mHash = MultiKey.hashCode(component);
    }

    public Object getComponent() {
        return this.mComponent;
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey key = (MultiKey)other;
            return MultiKey.equals(this.mComponent, key.mComponent);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.append(buf, this.mComponent);
        return buf.toString();
    }

    private void append(StringBuffer buf, Object obj) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (!obj.getClass().isArray()) {
            buf.append(obj);
            return;
        }
        buf.append('[');
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                this.append(buf, array[i]);
            }
        } else if (obj instanceof int[]) {
            int[] array = (int[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof float[]) {
            float[] array = (float[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof long[]) {
            long[] array = (long[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof double[]) {
            double[] array = (double[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof char[]) {
            char[] array = (char[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else if (obj instanceof short[]) {
            short[] array = (short[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
        } else {
            buf.append(obj);
        }
        buf.append(']');
    }
}

