/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeBuilder;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.classfile.generics.ClassTypeDesc;
import org.teatrove.trove.classfile.generics.GenericArrayTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.classfile.generics.ParameterizedTypeDesc;
import org.teatrove.trove.generics.GenericType;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.IdentityMap;
import org.teatrove.trove.util.MultiKey;
import org.teatrove.trove.util.UsageSet;

public class MergedClass {
    private static Map cMergedMap;
    public static final int OBSERVER_DISABLED = 0;
    public static final int OBSERVER_ENABLED = 1;
    public static final int OBSERVER_ACTIVE = 2;
    public static final int OBSERVER_EXTERNAL = 4;

    public static Constructor getConstructor(ClassInjector injector, Class[] classes) throws IllegalArgumentException {
        return MergedClass.getConstructor(injector, classes, null, 0);
    }

    public static Constructor getConstructor(ClassInjector injector, Class[] classes, String[] prefixes) throws IllegalArgumentException {
        return MergedClass.getConstructor(injector, classes, prefixes, 0);
    }

    public static Constructor getConstructor(ClassInjector injector, Class[] classes, String[] prefixes, int observerMode) throws IllegalArgumentException {
        if (classes.length > 254) {
            throw new IllegalArgumentException("More than 254 merged classes: " + classes.length);
        }
        Class clazz = MergedClass.getMergedClass(injector, classes, prefixes, observerMode);
        try {
            if ((observerMode & 1) == 0) {
                return clazz.getConstructor(classes);
            }
            ArrayList<Class> classList = new ArrayList<Class>(classes.length + 1);
            classList.add(InvocationEventObserver.class);
            for (int i = 0; i < classes.length; ++i) {
                classList.add(classes[i]);
            }
            return clazz.getConstructor(classList.toArray(new Class[classList.size()]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
    }

    public static Constructor getConstructor2(ClassInjector injector, Class[] classes) throws IllegalArgumentException {
        return MergedClass.getConstructor2(injector, classes, null, 0);
    }

    public static Constructor getConstructor2(ClassInjector injector, Class[] classes, String[] prefixes) throws IllegalArgumentException {
        return MergedClass.getConstructor2(injector, classes, prefixes, 0);
    }

    public static Constructor getConstructor2(ClassInjector injector, Class[] classes, String[] prefixes, int observerMode) throws IllegalArgumentException {
        Class clazz = MergedClass.getMergedClass(injector, classes, prefixes, observerMode);
        try {
            if ((observerMode & 1) != 0) {
                return clazz.getConstructor(InstanceFactory.class, InvocationEventObserver.class);
            }
            return clazz.getConstructor(InstanceFactory.class);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
    }

    public static ClassFile buildClassFile(String className, Class[] classes) throws IllegalArgumentException {
        return MergedClass.buildClassFile(className, classes, null, 0);
    }

    public static ClassFile buildClassFile(String className, Class[] classes, String[] prefixes) {
        return MergedClass.buildClassFile(className, classes, prefixes, 0);
    }

    public static ClassFile buildClassFile(String className, Class[] classes, String[] prefixes, int observerMode) throws IllegalArgumentException {
        ClassEntry[] classEntries = new ClassEntry[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            if (prefixes == null || i >= prefixes.length) {
                classEntries[i] = new ClassEntry(classes[i]);
                continue;
            }
            String prefix = prefixes[i];
            if (prefix != null && prefix.length() == 0) {
                prefix = null;
            }
            classEntries[i] = new ClassEntry(classes[i], prefix);
        }
        return MergedClass.buildClassFile(null, className, classEntries, observerMode);
    }

    private static Class getMergedClass(ClassInjector injector, Class[] classes, String[] prefixes, int observerMode) throws IllegalArgumentException {
        ClassEntry[] classEntries = new ClassEntry[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                classes[i] = injector.loadClass(classes[i].getName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to load class from injector: " + classes[i]);
            }
            if (prefixes == null || i >= prefixes.length) {
                classEntries[i] = new ClassEntry(classes[i]);
                continue;
            }
            String prefix = prefixes[i];
            if (prefix != null && prefix.length() == 0) {
                prefix = null;
            }
            classEntries[i] = new ClassEntry(classes[i], prefix);
        }
        return MergedClass.getMergedClass(injector, classEntries, observerMode);
    }

    private static synchronized Class getMergedClass(ClassInjector injector, ClassEntry[] classEntries, int observerMode) throws IllegalArgumentException {
        Class<?> merged;
        ClassFile cf;
        Object key;
        String mergedName;
        HashMap<Object, String> classListMap = (HashMap<Object, String>)cMergedMap.get(injector);
        if (classListMap == null) {
            classListMap = new HashMap<Object, String>(7);
            cMergedMap.put(injector, classListMap);
        }
        if ((mergedName = (String)classListMap.get(key = MergedClass.generateKey(classEntries))) != null) {
            try {
                return injector.loadClass(mergedName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            cf = MergedClass.buildClassFile(injector, null, classEntries, observerMode);
        }
        catch (IllegalArgumentException e) {
            e.fillInStackTrace();
            throw e;
        }
        try {
            OutputStream stream = injector.getStream(cf.getClassName());
            cf.writeTo(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new InternalError(e.toString());
        }
        try {
            merged = injector.loadClass(cf.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.toString());
        }
        classListMap.put(key, merged.getName());
        return merged;
    }

    private static Object generateKey(ClassEntry[] classEntries) {
        int length = classEntries.length;
        Object[] mainElements = new Object[length];
        for (int i = 0; i < length; ++i) {
            ClassEntry classEntry = classEntries[i];
            mainElements[i] = new MultiKey(new Object[]{classEntry.getClazz().getName(), classEntry.getMethodPrefix()});
        }
        return new MultiKey(mainElements);
    }

    private static ClassFile buildClassFile(ClassInjector injector, String className, ClassEntry[] classEntries, int observerMode) throws IllegalArgumentException {
        CodeBuilder builder;
        Method instanceFactoryMethod;
        UsageSet classSet = new UsageSet(classEntries.length * 2 + 1);
        HashSet<ClassEntry> nonConflictingClasses = new HashSet<ClassEntry>(classEntries.length * 2 + 1);
        String commonPackage = null;
        HashMap<MethodEntry, MethodEntry> methodMap = new HashMap<MethodEntry, MethodEntry>();
        for (int i = 0; i < classEntries.length; ++i) {
            ClassEntry classEntry = classEntries[i];
            Class clazz = classEntry.getClazz();
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException("Merged classes cannot be primitive: " + clazz);
            }
            if (!classSet.add(classEntry)) {
                throw new IllegalArgumentException("Class is specified more than once: " + clazz);
            }
            if (!Modifier.isPublic(clazz.getModifiers())) {
                String classPackage = clazz.getName();
                int index = classPackage.lastIndexOf(46);
                classPackage = index < 0 ? "" : classPackage.substring(0, index);
                if (commonPackage == null) {
                    commonPackage = classPackage;
                } else if (!commonPackage.equals(classPackage)) {
                    throw new IllegalArgumentException("Not all non-public classes defined in same package: " + commonPackage);
                }
            }
            nonConflictingClasses.add(classEntry);
            Method[] methods = clazz.getMethods();
            String prefix = classEntry.getMethodPrefix();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                String name = method.getName();
                if ("getObserverMode".equals(name) || "getInvocationObserver".equals(name) || "<clinit>".equals(name)) continue;
                MethodEntry methodEntry = new MethodEntry(clazz, method, name);
                MethodEntry existing = (MethodEntry)methodMap.get(methodEntry);
                if (existing == null) {
                    methodMap.put(methodEntry, methodEntry);
                } else if (existing.returnTypeDiffers(methodEntry)) {
                    nonConflictingClasses.remove(classEntry);
                    if (prefix == null) {
                        throw new IllegalArgumentException("Conflicting return types: " + existing + ", " + methodEntry);
                    }
                }
                if (prefix == null) continue;
                name = prefix + name;
                methodEntry = new MethodEntry(clazz, method, name);
                existing = (MethodEntry)methodMap.get(methodEntry);
                if (existing == null) {
                    methodMap.put(methodEntry, methodEntry);
                    continue;
                }
                if (!existing.returnTypeDiffers(methodEntry)) continue;
                nonConflictingClasses.remove(classEntry);
                throw new IllegalArgumentException("Conflicting return types: " + existing + ", " + methodEntry);
            }
        }
        if (className == null) {
            int id = 0;
            Iterator it = classSet.iterator();
            while (it.hasNext()) {
                id = id * 31 + it.next().hashCode();
            }
            className = "MergedClass$";
            try {
                while (true) {
                    className = "MergedClass$" + ((long)id & 0xFFFFFFFFL);
                    if (commonPackage != null && commonPackage.length() > 0) {
                        className = commonPackage + '.' + className;
                    }
                    try {
                        injector.loadClass(className);
                    }
                    catch (LinkageError e) {
                        // empty catch block
                    }
                    ++id;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        ClassFile cf = new ClassFile(className);
        cf.getModifiers().setFinal(true);
        cf.markSynthetic();
        for (int i = 0; i < classEntries.length; ++i) {
            ClassEntry classEntry = classEntries[i];
            if (!nonConflictingClasses.contains(classEntry)) continue;
            MergedClass.addAllInterfaces(cf, classEntry.getClazz());
        }
        Modifiers privateAccess = new Modifiers();
        privateAccess.setPrivate(true);
        Modifiers privateFinalAccess = new Modifiers();
        privateFinalAccess.setPrivate(true);
        privateFinalAccess.setFinal(true);
        Modifiers publicAccess = new Modifiers();
        publicAccess.setPublic(true);
        Modifiers privateStaticAccess = new Modifiers();
        privateStaticAccess.setPrivate(true);
        privateStaticAccess.setStatic(true);
        privateStaticAccess.setStatic(true);
        Modifiers publicStaticAccess = new Modifiers();
        publicStaticAccess.setPublic(true);
        publicStaticAccess.setStatic(true);
        TypeDesc instanceFactoryType = TypeDesc.forClass(InstanceFactory.class);
        cf.addField(privateAccess, "instanceFactory", instanceFactoryType).markSynthetic();
        try {
            instanceFactoryMethod = InstanceFactory.class.getMethod("getInstance", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        MethodInfo mo = cf.addMethod(publicStaticAccess, "getObserverMode", TypeDesc.forClass(Integer.TYPE), new TypeDesc[0]);
        mo.markSynthetic();
        CodeBuilder a = new CodeBuilder(mo);
        a.loadConstant(observerMode);
        a.returnValue(TypeDesc.forClass(Integer.TYPE));
        a = null;
        TypeDesc methodObserverType = TypeDesc.forClass(InvocationEventObserver.class);
        if ((observerMode & 1) != 0) {
            cf.addField(privateStaticAccess, "mInvocationObserver", methodObserverType).markSynthetic();
            MethodInfo me = cf.addMethod(publicStaticAccess, "getInvocationObserver", methodObserverType, new TypeDesc[0]);
            me.markSynthetic();
            CodeBuilder b = new CodeBuilder(me);
            b.loadStaticField("mInvocationObserver", methodObserverType);
            b.returnValue(TypeDesc.OBJECT);
            b = null;
        }
        String[] fieldNames = new String[classEntries.length];
        TypeDesc[] types = new TypeDesc[classEntries.length];
        for (int i = 0; i < classEntries.length; ++i) {
            Class clazz = classEntries[i].getClazz();
            String fieldName = "m$" + i;
            TypeDesc type = TypeDesc.forClass(clazz);
            cf.addField(privateAccess, fieldName, type).markSynthetic();
            fieldNames[i] = fieldName;
            types[i] = type;
            MethodInfo mi = cf.addMethod(privateFinalAccess, fieldName, type, new TypeDesc[0]);
            mi.markSynthetic();
            CodeBuilder builder2 = new CodeBuilder(mi);
            builder2.loadThis();
            builder2.loadField(fieldName, type);
            builder2.dup();
            Label isNull = builder2.createLabel();
            builder2.ifNullBranch(isNull, true);
            builder2.returnValue(TypeDesc.OBJECT);
            isNull.setLocation();
            builder2.pop();
            builder2.loadThis();
            builder2.loadField("instanceFactory", instanceFactoryType);
            builder2.dup();
            Label haveInstanceFactory = builder2.createLabel();
            builder2.ifNullBranch(haveInstanceFactory, false);
            builder2.loadConstant(null);
            builder2.returnValue(TypeDesc.OBJECT);
            haveInstanceFactory.setLocation();
            builder2.loadConstant(i);
            builder2.invoke(instanceFactoryMethod);
            builder2.checkCast(type);
            builder2.dup();
            builder2.loadThis();
            builder2.swap();
            builder2.storeField(fieldName, type);
            builder2.returnValue(TypeDesc.OBJECT);
        }
        if (classEntries.length <= 254) {
            MethodInfo mi = null;
            if ((observerMode & 1) == 0) {
                mi = cf.addConstructor(publicAccess, types);
            } else {
                ArrayList<TypeDesc> typesList = new ArrayList<TypeDesc>(types.length + 1);
                typesList.add(methodObserverType);
                for (int i = 0; i < types.length; ++i) {
                    typesList.add(types[i]);
                }
                mi = cf.addConstructor(publicAccess, typesList.toArray(new TypeDesc[typesList.size()]));
            }
            builder = new CodeBuilder(mi);
            builder.loadThis();
            builder.invokeSuperConstructor(new TypeDesc[0]);
            LocalVariable[] params = builder.getParameters();
            int j = 0;
            if ((observerMode & 1) != 0) {
                ++j;
                builder.loadThis();
                builder.loadLocal(params[0]);
                builder.storeStaticField("mInvocationObserver", methodObserverType);
            }
            int i = 0;
            while (i < classEntries.length) {
                builder.loadThis();
                builder.loadLocal(params[j]);
                builder.storeField(fieldNames[i], types[i]);
                ++i;
                ++j;
            }
            builder.returnVoid();
            builder = null;
        }
        MethodInfo mi = null;
        mi = (observerMode & 1) == 0 ? cf.addConstructor(publicAccess, instanceFactoryType) : cf.addConstructor(publicAccess, instanceFactoryType, methodObserverType);
        builder = new CodeBuilder(mi);
        builder.loadThis();
        builder.invokeSuperConstructor(new TypeDesc[0]);
        builder.loadThis();
        builder.loadLocal(builder.getParameters()[0]);
        builder.storeField("instanceFactory", instanceFactoryType);
        if ((observerMode & 1) != 0) {
            builder.loadThis();
            builder.loadLocal(builder.getParameters()[1]);
            builder.storeStaticField("mInvocationObserver", methodObserverType);
        }
        builder.returnVoid();
        builder = null;
        Set methodSet = methodMap.keySet();
        for (int i = 0; i < classEntries.length; ++i) {
            ClassEntry classEntry = classEntries[i];
            String prefix = classEntry.getMethodPrefix();
            String fieldName = fieldNames[i];
            TypeDesc type = types[i];
            Class clazz = classEntry.getClazz();
            Method[] methods = clazz.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                if ("<clinit>".equals(method.getName()) || "getObserverMode".equals(method.getName()) || "getInvocationObserver".equals(method.getName())) continue;
                MethodEntry methodEntry = new MethodEntry(clazz, method);
                if (methodSet.contains(methodEntry)) {
                    methodSet.remove(methodEntry);
                    MergedClass.addWrapperMethod(cf, methodEntry, fieldName, type, (observerMode & 1) != 0 && (observerMode & 2) != 0);
                }
                if (prefix == null || !methodSet.contains(methodEntry = new MethodEntry(clazz, method, prefix + method.getName()))) continue;
                methodSet.remove(methodEntry);
                MergedClass.addWrapperMethod(cf, methodEntry, fieldName, type, (observerMode & 1) != 0 && (observerMode & 2) != 0);
            }
        }
        return cf;
    }

    private static void addAllInterfaces(ClassFile cf, Class clazz) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            cf.addInterface(clazz);
        }
        MergedClass.addAllInterfaces(cf, clazz.getSuperclass());
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            MergedClass.addAllInterfaces(cf, interfaces[i]);
        }
    }

    private static GenericTypeDesc resolve(GenericType type) {
        Type genericType = type.getGenericType();
        if (genericType instanceof Class) {
            return GenericTypeFactory.fromType(genericType);
        }
        if (genericType instanceof TypeVariable) {
            return MergedClass.resolve(type.getRawType());
        }
        if (genericType instanceof ParameterizedType) {
            GenericType[] args = type.getTypeArguments();
            GenericTypeDesc[] argDescs = new GenericTypeDesc[args.length];
            for (int i = 0; i < args.length; ++i) {
                argDescs[i] = MergedClass.resolve(args[i]);
            }
            return ParameterizedTypeDesc.forType((ClassTypeDesc)GenericTypeFactory.fromType(type.getRawType().getType()), argDescs);
        }
        if (genericType instanceof WildcardType) {
            return MergedClass.resolve(type.getRawType());
        }
        if (genericType instanceof GenericArrayType) {
            GenericTypeDesc compType = MergedClass.resolve(type.getRootComponentType());
            for (int i = 0; i < type.getDimensions(); ++i) {
                compType = GenericArrayTypeDesc.forType(compType);
            }
            return compType;
        }
        throw new IllegalStateException("invalid type: " + type);
    }

    private static void addWrapperMethod(ClassFile cf, MethodEntry methodEntry, String fieldName, TypeDesc type, boolean observeMethods) {
        Class methodType = methodEntry.getType();
        Method method = methodEntry.getMethod();
        TypeDesc methodObserverType = TypeDesc.forClass(InvocationEventObserver.class);
        if (MergedClass.isDefinedInObject(method)) {
            return;
        }
        Modifiers modifiers = new Modifiers(method.getModifiers());
        modifiers.setAbstract(false);
        modifiers.setFinal(true);
        modifiers.setSynchronized(false);
        modifiers.setNative(false);
        modifiers.setStatic(false);
        Modifiers staticModifiers = (Modifiers)modifiers.clone();
        staticModifiers.setStatic(true);
        GenericType returnType = new GenericType(new GenericType(methodType), method.getReturnType(), method.getGenericReturnType());
        TypeDesc ret = TypeDesc.forClass(returnType.getRawType().getType(), MergedClass.resolve(returnType));
        Class<?>[] paramClasses = method.getParameterTypes();
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            GenericType paramType = new GenericType(new GenericType(methodType), paramClasses[i], paramTypes[i]);
            params[i] = TypeDesc.forClass(paramType.getRawType().getType(), MergedClass.resolve(paramType));
        }
        MethodInfo mi = Modifier.isStatic(method.getModifiers()) ? cf.addMethod(staticModifiers, methodEntry.getName(), ret, params) : cf.addMethod(modifiers, methodEntry.getName(), ret, params);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            mi.addException(exceptions[i].getName());
        }
        CodeBuilder builder = new CodeBuilder(mi);
        LocalVariable retVal = null;
        if (method.getReturnType() != Void.TYPE) {
            retVal = builder.createLocalVariable("retVal", ret);
        }
        LocalVariable startTime = null;
        if (observeMethods) {
            startTime = builder.createLocalVariable("startTime", TypeDesc.forClass(Long.TYPE));
            builder.loadStaticField("mInvocationObserver", methodObserverType);
            builder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
            builder.storeLocal(startTime);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            builder.loadThis();
            builder.loadField(fieldName, type);
            Label isNonNull = builder.createLabel();
            builder.dup();
            builder.ifNullBranch(isNonNull, false);
            builder.pop();
            builder.loadThis();
            builder.invokePrivate(fieldName, type, new TypeDesc[0]);
            isNonNull.setLocation();
        }
        LocalVariable[] locals = builder.getParameters();
        for (int i = 0; i < locals.length; ++i) {
            builder.loadLocal(locals[i]);
        }
        builder.invoke(method);
        if (method.getReturnType() != Void.TYPE) {
            builder.storeLocal(retVal);
        }
        if (observeMethods) {
            builder.loadStaticField("mInvocationObserver", methodObserverType);
            builder.loadConstant(null);
            builder.loadConstant(methodEntry.getName());
            builder.loadStaticField("mInvocationObserver", methodObserverType);
            builder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
            builder.loadLocal(startTime);
            builder.math((byte)101);
            builder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, TypeDesc.forClass(String.class), TypeDesc.forClass(String.class), TypeDesc.forClass(Long.TYPE));
        }
        if (method.getReturnType() == Void.TYPE) {
            builder.returnVoid();
        } else {
            builder.loadLocal(retVal);
            builder.returnValue(ret);
        }
    }

    private static boolean isDefinedInObject(Method method) {
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        Class<?>[] types = method.getParameterTypes();
        String name = method.getName();
        if (types.length == 0) {
            return "hashCode".equals(name) || "clone".equals(name) || "toString".equals(name) || "finalize".equals(name);
        }
        return types.length == 1 && types[0] == Object.class && "equals".equals(name);
    }

    private MergedClass() {
    }

    static {
        try {
            cMergedMap = new IdentityMap(7);
        }
        catch (LinkageError e) {
            cMergedMap = new HashMap(7);
        }
        catch (Exception e) {
            cMergedMap = new HashMap(7);
        }
    }

    private static class MethodEntry {
        private final Class mType;
        private final Method mMethod;
        private final String mName;
        private Class mReturn;
        private List mParams;
        private int mHashCode;

        public MethodEntry(Class type, Method method) {
            this(type, method, method.getName());
        }

        public MethodEntry(Class type, Method method, String name) {
            this.mType = type;
            this.mMethod = method;
            this.mName = name;
            this.mReturn = method.getReturnType();
            this.mParams = Arrays.asList(method.getParameterTypes());
            this.mHashCode = this.mName.hashCode() ^ this.mReturn.hashCode() ^ ((Object)this.mParams).hashCode();
        }

        public Class getType() {
            return this.mType;
        }

        public Method getMethod() {
            return this.mMethod;
        }

        public String getName() {
            return this.mName;
        }

        public boolean returnTypeDiffers(MethodEntry methodEntry) {
            return !this.getMethod().getReturnType().isAssignableFrom(methodEntry.getMethod().getReturnType()) && !methodEntry.getMethod().getReturnType().isAssignableFrom(this.getMethod().getReturnType());
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodEntry)) {
                return false;
            }
            MethodEntry methodEntry = (MethodEntry)other;
            return this.mName.equals(methodEntry.mName) && this.mReturn.equals(methodEntry.mReturn) && ((Object)this.mParams).equals(methodEntry.mParams);
        }

        public String toString() {
            return this.mMethod.toString();
        }
    }

    private static class ClassEntry {
        private final Class mClazz;
        private final String mPrefix;

        public ClassEntry(Class clazz) {
            this(clazz, null);
        }

        public ClassEntry(Class clazz, String prefix) {
            this.mClazz = clazz;
            this.mPrefix = prefix;
        }

        public Class getClazz() {
            return this.mClazz;
        }

        public String getMethodPrefix() {
            return this.mPrefix;
        }

        public int hashCode() {
            int hash = this.mClazz.getName().hashCode();
            return this.mPrefix == null ? hash : hash ^ this.mPrefix.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ClassEntry) {
                ClassEntry classEntry = (ClassEntry)other;
                if (this.mClazz == classEntry.mClazz) {
                    if (this.mPrefix == null) {
                        return classEntry.mPrefix == null;
                    }
                    return this.mPrefix.equals(classEntry.mPrefix);
                }
            }
            return false;
        }

        public String toString() {
            return this.mClazz.toString();
        }
    }

    public static interface InvocationEventObserver {
        public void invokedEvent(String var1, String var2, long var3);

        public long currentTime();
    }

    public static interface InstanceFactory {
        public Object getInstance(int var1);
    }
}

