/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityMap
extends AbstractMap
implements Map,
Cloneable {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    static final Iterator cEmptyHashIterator = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };
    private transient Entry[] mTable;
    private transient int mCount;
    private int mThreshold;
    private float mLoadFactor;
    private transient int mModCount = 0;
    private transient Set mKeySet = null;
    private transient Set mEntrySet = null;
    private transient Collection mValues = null;

    static String toString(Collection c) {
        StringBuffer buf = new StringBuffer();
        Iterator it = c.iterator();
        buf.append("[");
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(it.next()));
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public IdentityMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.mLoadFactor = loadFactor;
        this.mTable = new Entry[initialCapacity];
        this.mThreshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityMap() {
        this(11, 0.75f);
    }

    public IdentityMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean isEmpty() {
        return this.mCount == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry[] tab = this.mTable;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                Entry prev = null;
                while (e != null) {
                    if (e.getKey() == null) {
                        ++this.mModCount;
                        if (prev != null) {
                            prev.mNext = e.mNext;
                        } else {
                            tab[i] = e.mNext;
                        }
                        --this.mCount;
                    } else {
                        if (e.mValue == null) {
                            return true;
                        }
                        prev = e;
                    }
                    e = e.mNext;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                Entry prev = null;
                while (e != null) {
                    if (e.getKey() == null) {
                        ++this.mModCount;
                        if (prev != null) {
                            prev.mNext = e.mNext;
                        } else {
                            tab[i] = e.mNext;
                        }
                        --this.mCount;
                    } else {
                        if (value.equals(e.mValue)) {
                            return true;
                        }
                        prev = e;
                    }
                    e = e.mNext;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Entry[] tab = this.mTable;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object entryKey = e.getKey();
            if (entryKey == null) {
                ++this.mModCount;
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && key == entryKey) {
                    return true;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return false;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Entry[] tab = this.mTable;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object entryKey = e.getKey();
            if (entryKey == null) {
                ++this.mModCount;
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && key == entryKey) {
                    return e.mValue;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return null;
    }

    private void cleanup() {
        Entry[] tab = this.mTable;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                if (e.getKey() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[i] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    prev = e;
                }
                e = e.mNext;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.mTable.length;
        Entry[] oldMap = this.mTable;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.mModCount;
        this.mThreshold = (int)((float)newCapacity * this.mLoadFactor);
        this.mTable = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.mNext;
                if (e.getKey() == null) {
                    --this.mCount;
                    continue;
                }
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null key is not permitted");
        }
        Entry[] tab = this.mTable;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object entryKey = e.getKey();
            if (entryKey == null) {
                ++this.mModCount;
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && key == entryKey) {
                    Object old = e.mValue;
                    e.mValue = value;
                    return old;
                }
                prev = e;
            }
            e = e.mNext;
        }
        ++this.mModCount;
        if (this.mCount >= this.mThreshold) {
            this.cleanup();
        }
        if (this.mCount >= this.mThreshold) {
            this.rehash();
            tab = this.mTable;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.mCount;
        return null;
    }

    public Object remove(Object key) {
        Entry[] tab = this.mTable;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object entryKey = e.getKey();
            if (entryKey == null) {
                ++this.mModCount;
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && key == entryKey) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                    Object oldValue = e.mValue;
                    e.mValue = null;
                    return oldValue;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return null;
    }

    public void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Entry[] tab = this.mTable;
        ++this.mModCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.mCount = 0;
    }

    @Override
    public Object clone() {
        try {
            IdentityMap t = (IdentityMap)super.clone();
            t.mTable = new Entry[this.mTable.length];
            int i = this.mTable.length;
            while (i-- > 0) {
                t.mTable[i] = this.mTable[i] != null ? (Entry)this.mTable[i].clone() : null;
            }
            t.mKeySet = null;
            t.mEntrySet = null;
            t.mValues = null;
            t.mModCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityMap.this.getHashIterator(0);
                }

                @Override
                public int size() {
                    return IdentityMap.this.mCount;
                }

                @Override
                public boolean contains(Object o) {
                    return IdentityMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return o == null ? false : IdentityMap.this.remove(o) == o;
                }

                @Override
                public void clear() {
                    IdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mKeySet;
    }

    public Collection values() {
        if (this.mValues == null) {
            this.mValues = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return IdentityMap.this.getHashIterator(1);
                }

                @Override
                public int size() {
                    return IdentityMap.this.mCount;
                }

                @Override
                public boolean contains(Object o) {
                    return IdentityMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    IdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mValues;
    }

    public Set entrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityMap.this.getHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityMap.this.mTable;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryKey = e.getKey();
                        if (entryKey == null) {
                            IdentityMap.this.mModCount++;
                            if (prev != null) {
                                prev.mNext = e.mNext;
                            } else {
                                tab[index] = e.mNext;
                            }
                            IdentityMap.this.mCount--;
                        } else {
                            if (e.mHash == hash && e.identityEquals(entry)) {
                                return true;
                            }
                            prev = e;
                        }
                        e = e.mNext;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityMap.this.mTable;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryKey = e.getKey();
                        if (entryKey == null) {
                            IdentityMap.this.mModCount++;
                            if (prev != null) {
                                prev.mNext = e.mNext;
                            } else {
                                tab[index] = e.mNext;
                            }
                            IdentityMap.this.mCount--;
                        } else {
                            if (e.mHash == hash && e.identityEquals(entry)) {
                                IdentityMap.this.mModCount++;
                                if (prev != null) {
                                    prev.mNext = e.mNext;
                                } else {
                                    tab[index] = e.mNext;
                                }
                                IdentityMap.this.mCount--;
                                e.mValue = null;
                                return true;
                            }
                            prev = e;
                        }
                        e = e.mNext;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IdentityMap.this.mCount;
                }

                @Override
                public void clear() {
                    IdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mEntrySet;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.entrySet().iterator();
        buf.append("{");
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            Map.Entry e = (Map.Entry)it.next();
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private Iterator getHashIterator(int type) {
        if (this.mCount == 0) {
            return cEmptyHashIterator;
        }
        return new HashIterator(type);
    }

    private class HashIterator
    implements Iterator {
        private Entry[] mTable;
        private int mIndex;
        private Entry mEntry;
        private Object mEntryKey;
        private Entry mLastReturned;
        private int mType;
        private int expectedModCount;

        HashIterator(int type) {
            this.mTable = IdentityMap.this.mTable;
            this.mIndex = this.mTable.length;
            this.expectedModCount = IdentityMap.this.mModCount;
            this.mType = type;
        }

        @Override
        public boolean hasNext() {
            while (this.mEntry == null || (this.mEntryKey = this.mEntry.getKey()) == null) {
                if (this.mEntry != null) {
                    this.remove(this.mEntry);
                    this.mEntry = this.mEntry.mNext;
                    continue;
                }
                if (this.mIndex <= 0) {
                    return false;
                }
                this.mEntry = this.mTable[--this.mIndex];
            }
            return true;
        }

        public Object next() {
            if (IdentityMap.this.mModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mLastReturned = this.mEntry;
            this.mEntry = this.mEntry.mNext;
            return this.mType == 0 ? this.mLastReturned.getKey() : (this.mType == 1 ? this.mLastReturned.getValue() : this.mLastReturned);
        }

        @Override
        public void remove() {
            if (this.mLastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityMap.this.mModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.mLastReturned);
            this.mLastReturned = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.mTable;
            int index = (toRemove.mHash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    IdentityMap.this.mModCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    IdentityMap.this.mCount--;
                    return;
                }
                prev = e;
                e = e.mNext;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        int mHash;
        Object mValue;
        Entry mNext;

        Entry(int hash, Object key, Object value, Entry next) {
            super(key);
            this.mHash = hash;
            this.mValue = value;
            this.mNext = next;
        }

        @Override
        protected Object clone() {
            return new Entry(this.mHash, this.getKey(), this.mValue, this.mNext == null ? null : (Entry)this.mNext.clone());
        }

        public Object getKey() {
            return this.get();
        }

        public Object getValue() {
            return this.mValue;
        }

        public Object setValue(Object value) {
            Object oldValue = this.mValue;
            this.mValue = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = this.getKey();
            return (key == null ? e.getKey() == null : key.equals(e.getKey())) && (this.mValue == null ? e.getValue() == null : this.mValue.equals(e.getValue()));
        }

        public boolean identityEquals(Map.Entry e) {
            return this.getKey() == e.getKey() && (this.mValue == null ? e.getValue() == null : this.mValue.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.mHash ^ (this.mValue == null ? 0 : this.mValue.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.mValue;
        }
    }
}

