/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.IdentityMap;
import org.teatrove.trove.util.NullKeyMap;

public class DelegatingClassInjector
extends ClassInjector {
    private static Map cShared = new NullKeyMap(new IdentityMap());
    private ClassLoader mSuperLoader;
    private File[] mRootClassDirs;
    private String mRootPackage;
    private boolean mStoreBytecode;
    private Map m_loaderMap;

    public static ClassInjector getInstance() {
        return DelegatingClassInjector.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInjector getInstance(ClassLoader loader) {
        ClassInjector injector = null;
        Map map = cShared;
        synchronized (map) {
            Reference ref = (Reference)cShared.get(loader);
            if (ref != null) {
                injector = (ClassInjector)ref.get();
            }
            if (injector == null) {
                injector = new ClassInjector(loader);
                cShared.put(loader, new WeakReference<ClassInjector>(injector));
            }
            return injector;
        }
    }

    public DelegatingClassInjector() {
        this(null, (File[])null, null);
    }

    public DelegatingClassInjector(ClassLoader parent) {
        this(parent, (File[])null, null);
    }

    public DelegatingClassInjector(File rootClassDir, String rootPackage) {
        File[] fileArray;
        if (rootClassDir == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = rootClassDir;
        }
        this(null, fileArray, rootPackage);
    }

    public DelegatingClassInjector(ClassLoader parent, File rootClassDir, String rootPackage) {
        File[] fileArray;
        if (rootClassDir == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = rootClassDir;
        }
        this(parent, fileArray, rootPackage);
    }

    public DelegatingClassInjector(File[] rootClassDirs, String rootPackage) {
        this(null, rootClassDirs, rootPackage);
    }

    public DelegatingClassInjector(ClassLoader parent, File[] rootClassDirs, String rootPackage) {
        this(parent, rootClassDirs, rootPackage, false);
    }

    public DelegatingClassInjector(ClassLoader parent, File[] rootClassDirs, String rootPackage, boolean keepRawBytecode) {
        this.m_loaderMap = Collections.synchronizedMap(new HashMap());
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        this.mSuperLoader = parent;
        if (rootClassDirs != null) {
            this.mRootClassDirs = (File[])rootClassDirs.clone();
        }
        if (rootPackage != null && !rootPackage.endsWith(".")) {
            rootPackage = rootPackage + '.';
        }
        this.mRootPackage = rootPackage;
        this.mStoreBytecode = keepRawBytecode;
    }

    @Override
    public URL getResource(String name) {
        return this.mSuperLoader.getResource(name);
    }

    private ClassInjector getSubLoader(String name) {
        ClassInjector ci = (ClassInjector)this.m_loaderMap.get(name);
        if (ci == null) {
            ci = new ClassInjector(null, this.mRootClassDirs, this.mRootPackage, this.mStoreBytecode);
            this.m_loaderMap.put(name, ci);
        }
        return ci;
    }

    @Override
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.getSubLoader(name).loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null && this.mSuperLoader != null) {
            clazz = this.mSuperLoader.loadClass(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    @Override
    protected void define(String name, byte[] data) {
        this.getSubLoader(name).define(name, data);
    }
}

